package com.github.wxiaoqi.security.admin.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;


/**
 * 店铺banner
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-11 11:06:45
 */
@Data
@Table(name = "branch_company_banner")
public class BranchCompanyBanner implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    //主键id
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键id")
    private Long id;



	@Column(name = "company_id")
	@ApiModelProperty(value = "店铺id")
	private Integer companyId;
	

    @Column(name = "name")
	@ApiModelProperty(value = "banner名称")
    private String name;
	

    @Column(name = "cover")
	@ApiModelProperty(value = "封面")
    private String cover;


    @Column(name = "rank")
	@ApiModelProperty(value = "排序")
    private Integer rank;
	

    @Column(name = "url")
	@ApiModelProperty(value = "地址url")
    private String url;



    @Column(name = "status")
	@ApiModelProperty(value = "状态：1-上架；2-上架")
    private Integer status;


	@Column(name = "crt_time")
	private Long crtTime;


	@Column(name = "upd_time")
	private Long updTime;
	

    @Column(name = "is_del")
	@ApiModelProperty(value = "是否删除；0-正常；1-删除")
    private Integer isDel;
	


}
