package com.github.wxiaoqi.security.admin.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;


/**
 * 营收明细表
 * 
 * @author zjw
 * @email 18178966185@163.com
 * @date 2019-07-11 14:14:54
 */
@Data
@Table(name = "base_order_revenue")
public class BaseOrderRevenue implements Serializable {
	private static final long serialVersionUID = 1L;

	@Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键id")
    private Integer id;


	@Column(name = "company_id")
	@ApiModelProperty("店铺id")
    private Integer companyId;



	@Column(name = "order_no")
	@ApiModelProperty(value = "订单号")
	private String orderNo;



	@Column(name = "user_id")
	@ApiModelProperty(value = "下单用户id")
	private Integer userId;

	

    @Column(name = "type")
	@ApiModelProperty(value = "类型s;逗号隔开")
    private String type;
	


    @Column(name = "amount")
	@ApiModelProperty(value = "进账金额")
    private BigDecimal amount;



	@Column(name = "status")
	@ApiModelProperty(value = "状态：0-待结算；1-未提现；2-提现成功；3-提现失败")
	private Integer status;
	


    @Column(name = "reson")
	@ApiModelProperty(value = "失败原因")
    private String reson;
	


    @Column(name = "cath_amount")
	@ApiModelProperty(value = "提现金额")
    private BigDecimal cathAmount;
	


    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间")
    private Long crtTime;
	

	

    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;
	


    @Column(name = "is_del")
	@ApiModelProperty(value = "是否删除：0-正常；1-删除")
    private Integer isDel;
	

}
