package com.xxfc.platform.vehicle.entity;

import lombok.Data;

import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import java.util.Date;

/**
 *车辆相关预警消息
 *
 */
@Data
@Table(name = "vehicle_warning_msg")
public class VehicleWarningMsg {

    @Id
    @GeneratedValue(strategy= GenerationType.IDENTITY)
    public Integer id;
    /**
     * 消息类型，详见VehicleMsgType
     */
    public Integer type;

    /**
     * 颜色预警：1、红色预警，2、蓝色预警、3、黄色预警
     */
    private Integer colorType;

    /**
     * 消息类型，详见VehicleMsgStatus
     */
    public Integer status;

    /**
     * 消息内容
     */
    private String msg;

    /**
     * 对应规则ID
     */
    private Integer ruleId;

    /**
     * 对应车辆ID
     */
    private String vehicleId;

    /**
     * 消息key，用于去重
     */
    private String msgKey;

    /**
     * 备注
     */
    private String remark;

    private Date createTime;

    private Date updateTime;
}
