package com.xxfc.platform.order.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.order.biz.OrderInvoiceBiz;
import com.xxfc.platform.order.entity.OrderInvoice;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 发票记录
 */
@RestController
@RequestMapping(value = "/order/invoice")
public class OrderInvoiceController extends BaseController<OrderInvoiceBiz, OrderInvoice> {

	@PostMapping(value = "/add")
	public ObjectRestResponse add(@RequestBody OrderInvoice orderInvoice) {
		return baseBiz.add(orderInvoice);
	}

	@GetMapping(value = "selectByOrderIds")
	public ObjectRestResponse<List<OrderInvoice>> selectByOrderIds(String orderIds) {
		return baseBiz.selectByIds(orderIds);
	}

	@GetMapping(value = "selectByType")
	public  ObjectRestResponse<List<OrderInvoice>> selectByToken(Integer type) {
		return baseBiz.selectByToken(type);
	}

	@GetMapping(value = "getByUser")
	public ObjectRestResponse<List<OrderInvoice>> selectByUserId(Integer userId, Integer type) {
		return baseBiz.selectByUserId(userId, type);
	}

}
