package com.xxfc.platform.order.entity;

import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.math.BigDecimal;

@Table(name = "order_e_invoice")
@Data
public class OrderInvoice {
    /**
     * 主键
     */
    @Id
    private Integer id;

    /**
     * 发票类型：1--租房车；2--房车游；3--会员
     */
    private Integer type;

    /**
     * 订单ids，逗号分隔
     */
    @Column(name = "order_ids")
    private String orderIds;

    /**
     * 发票抬头类型：1--企业单位；2--个人/非企业单位
     */
    @Column(name = "title_type")
    private Integer titleType;

    /**
     * 抬头名称
     */
    @Column(name = "title_name")
    private String titleName;

    /**
     * 税号
     */
    @Column(name = "tax_code")
    private String taxCode;

    /**
     * 发票内容-备注说明
     */
    @Column(name = "content_remark")
    private String contentRemark;

    /**
     * 发票内容-地址和电话
     */
    @Column(name = "content_contact")
    private String contentContact;

    /**
     * 发票内容-开户行和账号
     */
    @Column(name = "content_account")
    private String contentAccount;

    /**
     * 发票方
     */
    private String drawer;

    /**
     * 金额
     */
    private BigDecimal amount;

    /**
     * 接收方式：1--邮件
     */
    @Column(name = "receive_type")
    private Integer receiveType;

    /**
     * 接收方式内容
     */
    @Column(name = "receive_content")
    private String receiveContent;

    /**
     * 创建时间
     */
    @Column(name = "crt_time")
    private Long crtTime;

    /**
     * 更新时间
     */
    @Column(name = "upd_time")
    private Long updTime;

    /**
     * 创建者id
     */
    @Column(name = "user_id")
    private Integer userId;

    /**
     * 更新者id
     */
    @Column(name = "user_upd")
    private Integer userUpd;

    /**
     * 更多内容
     */
    private String extend;

}