package com.github.wxiaoqi.security.admin.rest.admin;

import com.github.wxiaoqi.security.admin.biz.StaffStatisticsBiz;
import com.github.wxiaoqi.security.admin.dto.StaffStatisticsFindDTO;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.github.wxiaoqi.security.common.exception.BaseException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/11/26 16:59
 */
@RestController
@RequestMapping("/staff_statistics")
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
public class StaffStatisticsAdminController {

       private final StaffStatisticsBiz staffStatisticsBiz;

       @PostMapping("/page")
       public ObjectRestResponse<Map<String,Object>> lisetStaffStatisticsWithPage(@RequestBody StaffStatisticsFindDTO staffStatisticsFindDTO){
           Map<String,Object> result =  staffStatisticsBiz.listStaffStatisticsWithPage(staffStatisticsFindDTO);
           return ObjectRestResponse.succ(result);
       }

       @PostMapping("/export")
       public void exportStaffStatistics(@RequestBody StaffStatisticsFindDTO staffStatisticsFindDTO, HttpServletResponse response){
           try {
               String name = DateTimeFormatter.ofPattern("YYYYMMddHHmmss").format(LocalDateTime.now());
               response.setContentType("application/vnd.ms-excel;charset=utf-8");
               String filename = String.format("%s-staff-statistics.xlsx",name);
               response.setHeader("Content-Disposition","attachment;filename="+ new String(filename.getBytes(), "iso8859-1"));
               ServletOutputStream outputStream = response.getOutputStream();
               staffStatisticsBiz.exportStaffStistics(staffStatisticsFindDTO, outputStream);
               response.setCharacterEncoding("UTF-8");
           }catch (Exception ex){
               throw  new BaseException("导出数据失败");
           }
       }
}
