package com.xxfc.platform.vehicle.rest;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.common.msg.BaseResponse;
import com.xxfc.platform.vehicle.biz.VehicleWarningMsgBiz;
import com.xxfc.platform.vehicle.common.BaseController;
import com.xxfc.platform.vehicle.common.CustomIllegalParamException;
import com.xxfc.platform.vehicle.common.RestResponse;
import com.xxfc.platform.vehicle.constant.ResCode.ResCode;
import com.xxfc.platform.vehicle.entity.VehicleWarningMsg;
import com.xxfc.platform.vehicle.vo.AddVehicleWarningMsgVo;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.vehicle.vo.QueryVehicleWarningMsgVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

@RestController
@RequestMapping("/vehicleWarningMsg")
@IgnoreClientToken
@Slf4j
public class VehicleWarningMsgController extends BaseController<VehicleWarningMsgBiz> {

    @RequestMapping(value ="{id}",method = RequestMethod.GET)
    private RestResponse<VehicleWarningMsg> get(@PathVariable Integer id) throws Exception{
        return RestResponse.codeAndData(RestResponse.SUC_CODE,baseBiz.selectById(id));
    }


    @RequestMapping(value ="page",method = RequestMethod.GET)
    private RestResponse<PageDataVO<VehicleWarningMsg>> getByPage(@RequestParam String queryVehicleWarningMsgVoJson) throws Exception{
        QueryVehicleWarningMsgVo queryVehicleWarningMsgVo = null;
        try {
            queryVehicleWarningMsgVo = JSON.parseObject(queryVehicleWarningMsgVoJson, QueryVehicleWarningMsgVo.class);
            return RestResponse.data(baseBiz.getByPage(queryVehicleWarningMsgVo));
        } catch (JSONException ex) {
            return RestResponse.code(ResCode.INVALID_REST_REQ_PARAM.getCode());
        } catch (CustomIllegalParamException ex){
            return RestResponse.code(ResCode.INVALID_REST_REQ_PARAM.getCode());
        }
    }

    @RequestMapping(value ="",method = RequestMethod.POST)
    private RestResponse<Integer> add(@RequestBody AddVehicleWarningMsgVo addVehicleWarningMsgVo) throws Exception{
        new RestResponse<Map>().setData(new HashMap<String, Object>());
        return baseBiz.add(addVehicleWarningMsgVo);
    }

    @RequestMapping(value ="deal/{id}",method = RequestMethod.PUT)
    private RestResponse deal(@PathVariable Integer id) throws Exception{
        return baseBiz.deal(id);
    }
}
