package com.xxfc.platform.vehicle.biz;


import com.ace.cache.annotation.Cache;
import com.ace.cache.annotation.CacheClear;
import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.xxfc.platform.vehicle.common.RestResponse;
import com.xxfc.platform.vehicle.constant.RedisKey;
import com.xxfc.platform.vehicle.entity.VehicleCata;
import com.xxfc.platform.vehicle.entity.VehiclePlatCata;
import com.xxfc.platform.vehicle.mapper.VehiclePlatCataMapper;
import com.xxfc.platform.vehicle.vo.CataVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.weekend.WeekendSqls;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;


@Service
@Slf4j
public class VehiclePlatCataBiz extends BaseBiz<VehiclePlatCataMapper, VehiclePlatCata> {

    @Autowired
    VehicleCataBiz vehicleCataBiz;


    //更新
    @Transactional
    @CacheClear(pre = RedisKey.BRANCH_CATA_CACHE)
    public RestResponse update(CataVo cataVo){
        VehiclePlatCata vehiclePlatCata = new VehiclePlatCata();
        BeanUtils.copyProperties(cataVo,vehiclePlatCata);
        if(vehiclePlatCata.getId()==null||vehiclePlatCata.getId()==0){
            vehiclePlatCata.setUpdTime(System.currentTimeMillis());
            insertSelective(vehiclePlatCata);
        }else{
            updateSelectiveById(vehiclePlatCata);
        }
          return RestResponse.suc();
    }

    /**
     * 获取无限级的类别资源
     */
   @Transactional
   @Cache(key = RedisKey.BRANCH_COMPANY_CATA_ALL)
    public JSONObject findTypeTree() throws Exception {
        //默认查询出所有的一级类别
        JSONObject obj = new JSONObject();
        List<VehiclePlatCata> typeList = getAll(0);
        List<Object> list = new ArrayList<>();
        for (VehiclePlatCata cata : typeList) {
            JSONObject treeObject = new JSONObject();
            treeObject.put("id", cata.getId());
            treeObject.put("parentId", cata.getParentId());
            treeObject.put("name", cata.getName());
            treeObject.put("level", cata.getLevel());
            treeObject.put("icon", cata.getIcon());
            treeObject.put("children", getChildren(cata.getId()));
            list.add(treeObject);
        }
        obj.put("cata",list);
        return obj;
    }
    public List<Object> getChildren(Integer parentId){
        List<Object> list = new ArrayList<>();
        List<VehiclePlatCata> children = getAll(parentId);
     if(children.size()>0){
        for (VehiclePlatCata cata : children) {
            JSONObject obj = new JSONObject();
            obj.put("id", cata.getId());
            obj.put("parentId", cata.getParentId());
            obj.put("name", cata.getName());
            obj.put("level", cata.getLevel());
            obj.put("icon", cata.getIcon());
            obj.put("children", getChildren(cata.getId()));
            list.add(obj);
        }
      }
        return list;
    }

    public  List<VehiclePlatCata> getAll(Integer parentId){
        Example example = new Example(VehiclePlatCata.class);
        example.createCriteria().andEqualTo("parentId", parentId).andEqualTo("state",0);
        example.setOrderByClause("`rank` desc");
        return mapper.selectByExample(example);
    }

    /**
     * 根据车型获取
     * @param modelId
     * @return
     */
    public  List<VehiclePlatCata> getByModelId(Integer modelId){
        List<VehicleCata> vehicleCatas = vehicleCataBiz.selectByExample(new Example.Builder(VehicleCata.class)
                .where(WeekendSqls.<VehicleCata>custom().andEqualTo(VehicleCata::getVehicleModelId, modelId)).build());

        if(vehicleCatas.isEmpty()) {
            return new ArrayList<VehiclePlatCata>();
        }else {
            List<VehiclePlatCata> VehiclePlatCatas = this.selectByExample(new Example.Builder(VehiclePlatCata.class)
                    .where(WeekendSqls.<VehiclePlatCata>custom().andIn(VehiclePlatCata::getId
                            , vehicleCatas.parallelStream().map(VehicleCata::getCataId).distinct()
                                    .collect(Collectors.toList()))).build());
            return VehiclePlatCatas;
        }
    }

//    public List

}
