package com.xxfc.platform.vehicle.biz;


import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.xxfc.platform.vehicle.common.RestResponse;
import com.xxfc.platform.vehicle.entity.VehicleUserLicense;
import com.xxfc.platform.vehicle.mapper.VehicleLicenseMapper;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.vehicle.vo.VehicleUserLicenseVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;


@Service
@Slf4j
public class VehicleLicenseBiz extends BaseBiz<VehicleLicenseMapper, VehicleUserLicense> {

    //更新
    @Transactional
    public RestResponse update(VehicleUserLicenseVo licenseVo){
        VehicleUserLicense vehicleUserLicense = new VehicleUserLicense();
        BeanUtils.copyProperties(licenseVo,vehicleUserLicense);
        if(vehicleUserLicense.getId()==null||vehicleUserLicense.getId()==0){
            vehicleUserLicense.setUpdTime(System.currentTimeMillis());
            insertSelective(vehicleUserLicense);
        }else{
            updateSelectiveById(vehicleUserLicense);
        }
        return RestResponse.suc();
    }

    public PageDataVO<VehicleUserLicense> getAllByUserid(Integer page, Integer limit, Integer userid){
        Example example = new Example(VehicleUserLicense.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("userid",userid).andEqualTo("isdel",0);
        example.setOrderByClause("`id` desc");
        PageHelper.startPage(page,limit);
        PageInfo<VehicleUserLicense> campsitePageInfo = new PageInfo<VehicleUserLicense>(mapper.selectByExample(example));
        return PageDataVO.pageInfo(campsitePageInfo);
    }

    public VehicleUserLicense getOneById( Integer id){
        return mapper.selectByPrimaryKey(id);
    }
    public RestResponse del( Integer id){
        VehicleUserLicense vehicleUserLicense = new VehicleUserLicense();
        vehicleUserLicense.setId(id);
        vehicleUserLicense.setIsdel(1);
        updateSelectiveById(vehicleUserLicense);
        return RestResponse.suc();
    }

}
