package com.xxfc.platform.vehicle.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;


/**
 * 车型
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-05-25 14:50:08
 */
@Data
@Table(name = "vehicle_model")
public class VehicleModel implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    //主键
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键")
    private Integer id;
	
	    //名称
    @Column(name = "name")
	@ApiModelProperty(value = "名称")
    private String name;
	
	    //配置，code逗号分割
    @Column(name = "config")
	@ApiModelProperty(value = "配置，code逗号分割")
    private String config;
	
	    //关键字，code逗号分割
    @Column(name = "keyword")
	@ApiModelProperty(value = "关键字，code逗号分割")
    private String keyword;

		//房车展示
	@Column(name = "model_show")
	@ApiModelProperty(value = "房车展示")
	private String modelShow;

		//参数
	@Column(name = "model_param")
	@ApiModelProperty(value = "参数")
	private String modelParam;
	
	    //图片地址 多张为逗号分割
    @Column(name = "picture")
	@ApiModelProperty(value = "图片地址 多张为逗号分割")
    private String picture;

	//价格
	@Column(name = "price")
	@ApiModelProperty(value = "价格")
	private BigDecimal price;
	
	    //创建时间
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Date crtTime;
	
	    //创建者id
    @Column(name = "crt_user")
	@ApiModelProperty(value = "创建者id")
    private Integer crtUser;
	
	    //创建者名称
    @Column(name = "crt_name")
	@ApiModelProperty(value = "创建者名称")
    private String crtName;
	
	    //创建者host
    @Column(name = "crt_host")
	@ApiModelProperty(value = "创建者host")
    private String crtHost;
	
	    //修改时间
    @Column(name = "upd_time")
	@ApiModelProperty(value = "修改时间", hidden = true )
    private Date updTime;
	
	    //修改者
    @Column(name = "upd_user")
	@ApiModelProperty(value = "修改者")
    private Integer updUser;
	
	    //修改者名称
    @Column(name = "upd_name")
	@ApiModelProperty(value = "修改者名称")
    private String updName;
	
	    //修改者host
    @Column(name = "upd_host")
	@ApiModelProperty(value = "修改者host")
    private String updHost;

	//评分
	@Column(name = "score")
	@ApiModelProperty(value = "评分")
	private Integer score;
	

}
