package com.xxfc.platform.universal.controller;

import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.util.result.JsonResultUtil;
import com.xxfc.platform.universal.service.UploadService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;


/**
 * 图片上传
 */
@RestController
@RequestMapping("file")
@IgnoreUserToken
@Slf4j
public class UploadController{

       @Autowired
       UploadService uploadService;

      private static Integer MAX_DRIVING_LICENSE_SIZE = 10 * 1024 * 1024;//10M

     @RequestMapping(value = "/app/unauth/upload", method = RequestMethod.POST)
    public JSONObject upload(
            @RequestParam("file") MultipartFile file,
            @RequestParam(value = "prefix",defaultValue = "app")String prefix
     )throws Exception {
        String contentType = file.getContentType();   //图片文件类型
//        String fileName = file.getOriginalFilename();  //图片名字
       /* if (!contentType.equals("image/jpeg") && !contentType.equals("image/gif")&&!contentType.equals("image/png")) {
            return JsonResultUtil.createFailedResult(2001,"格式不对!!!");
        }*/
        if (file.getSize() > MAX_DRIVING_LICENSE_SIZE) {
            return JsonResultUtil.createFailedResult(2002,"大小超过限制!!!");
        }
        return JsonResultUtil.createSuccessResultWithObj(uploadService.uploadFile(file,prefix));
    }

    @IgnoreUserToken
    @RequestMapping(value = "/app/unauth/download", method = RequestMethod.GET) //匹配的是href中的download请求
    public ResponseEntity<byte[]> download(@RequestParam("realFileRelPath") String realFileRelPath) throws Exception {
        return uploadService.downloadFile(realFileRelPath);
    }

    @RequestMapping(value = "/app/unauth/uploadFiles", method = RequestMethod.POST)
    public JSONObject uploadFiles(
            @RequestParam("files") MultipartFile[] files,
            @RequestParam(value = "prefix",defaultValue = "app")String prefix
        )throws Exception {
        if(files!=null&&files.length>0){
            String urls="";
            for(int i = 0;i<files.length;i++){
                MultipartFile file = files[i];
                //保存文件
                String contentType = file.getContentType();
                if (file.getSize() > MAX_DRIVING_LICENSE_SIZE) {
                    log.error("大小超过限制!!!");
                    continue;
                }
                String path=uploadService.uploadFile(file,prefix);
                if(StringUtils.isBlank(urls)){
                    urls+=path;
                }else {
                    urls+=","+path;
                }

            }
            return JsonResultUtil.createSuccessResultWithObj(urls);

        }
        return JsonResultUtil.createDefaultFail();

    }
}

