/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.csp.sentinel.dashboard.inmem;

import com.taobao.csp.sentinel.dashboard.datasource.entity.RuleEntity;
import com.taobao.csp.sentinel.dashboard.discovery.MachineInfo;
import com.taobao.csp.sentinel.dashboard.inmem.RuleRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public abstract class InMemRepositoryAdapter<T extends RuleEntity>
implements RuleRepository<T, Long> {
    private Map<MachineInfo, Map<Long, T>> machineRules = new ConcurrentHashMap(16);
    private Map<Long, T> allRules = new ConcurrentHashMap(16);
    private static final int MAX_RULES_SIZE = 10000;

    public T save(T entity) {
        if (entity.getId() == null) {
            entity.setId(Long.valueOf(this.nextId()));
        }
        this.allRules.put(entity.getId(), entity);
        this.machineRules.computeIfAbsent(MachineInfo.of((String)entity.getApp(), (String)entity.getIp(), (Integer)entity.getPort()), e -> new ConcurrentHashMap(32)).put(entity.getId(), entity);
        return entity;
    }

    public List<T> saveAll(List<T> rules) {
        this.allRules.clear();
        this.machineRules.clear();
        if (rules == null) {
            return null;
        }
        ArrayList<RuleEntity> savedRules = new ArrayList<RuleEntity>(rules.size());
        for (RuleEntity rule : rules) {
            savedRules.add(this.save(rule));
        }
        return savedRules;
    }

    public T delete(Long id) {
        RuleEntity entity = (RuleEntity)this.allRules.remove(id);
        if (entity != null) {
            ((Map)this.machineRules.get(MachineInfo.of((String)entity.getApp(), (String)entity.getIp(), (Integer)entity.getPort()))).remove(id);
        }
        return (T)entity;
    }

    public T findById(Long id) {
        return (T)((RuleEntity)this.allRules.get(id));
    }

    public List<T> findAllByMachine(MachineInfo machineInfo) {
        Map entities = (Map)this.machineRules.get(machineInfo);
        if (entities == null) {
            return new ArrayList();
        }
        return entities.values().stream().collect(Collectors.toList());
    }

    protected abstract long nextId();
}

