package com.xxfc.platform.vehicle.pojo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Map;

@Data
public class BookVehicleVO {
    /**
     * 车辆id
     */
    @ApiModelProperty("车辆id")
    private String vehicleId;

    private Long vehicleBookRecordId;

    /**
     * 预定目标日期(开始)
     */
    @ApiModelProperty("预定目标日期(开始) yyyy-MM-dd HH:mm:ss")
    private String bookStartDate;

    /**
     * 预定目标日期(结束)
     */
    @ApiModelProperty("预定目标日期(结束) yyyy-MM-dd HH:mm:ss")
    private String bookEndDate;

    /**
     * 预定目标日期(开始)
     */
    @ApiModelProperty("预定目标时间(开始)")
    private String bookStartDateTime;

    /**
     * 预定目标日期(结束)
     */
    @ApiModelProperty("预定目标时间(结束)")
    private String bookEndDateTime;

    /**
     * 取消预定目标日期(开始)
     */
    @ApiModelProperty("取消预定目标日期(开始)")
    private String unbookStartDate;

    /**
     * 取消预定目标日期(结束)
     */
    @ApiModelProperty("取消预定目标日期(结束)")
    private String unbookEndDate;

    /**
     * 提车地点
     */
    @ApiModelProperty("提车地点")
    private String liftAddr;

    /**
     * 提车公司
     */
    @ApiModelProperty("提车公司")
    private Integer liftCompany;

    /**
     * 目的地
     */
    @ApiModelProperty("目的地")
    private String destination;

    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;

    /**
     * 随车物品id以及数量 List<Map<id,数量>>
     */
    @ApiModelProperty("随车物品id以及数量 List<Map<id,数量>>")
    Map<Integer,Integer> selectedAccItem;

    /**
     * 提车阶段里程数
     */
    @ApiModelProperty("提车阶段里程数")
    private Integer mileageLift;

    /**
     * 还车阶段里程数
     */
    @ApiModelProperty("还车阶段里程数")
    private Integer mileageRet;

    /**
     * 是否违章
     */
    @ApiModelProperty("是否违章")
    private Integer haveViolation;

    //还车分公司
    private Integer retCompany;

    /**
     * 预定车辆用途
     */
    private Integer bookType;

    //使用人姓名
    private String vehicleUsername;
    //使用人电话
    private String vehicleUserPhone;

    private String upkeepIds;

    private String orderNo;

    /**
     * book_record状态
     */
    private Integer status;

    /**
     * 驳回理由
     */
    private String rejectRemark;

    /**
     * 不检查参数合法
     */
    private Boolean notCheckTimeLegal;
}