package com.xxfc.platform.activity.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * @author libin
 * @version 1.0
 * @description 奖品、设置
 * @data 2019/12/3 15:21
 */
@Data
@Table(name = "activity_prize")
@ApiModel
public class ActivityPrize implements Serializable {
     private static final long serialVersionUID = 1L;
     @Id
     @GeneratedValue(generator = "JDBC")
     private Integer id;

     @NotNull(message = "编号不能为null")
     @ApiModelProperty("编号")
     @Column(name = "serial_number")
     private Integer serialNumber;

     @NotEmpty(message = "奖品名称不能为空")
     @Column(name = "name")
     private String name;

     @NotEmpty(message = "奖品地址不能为空")
     @ApiModelProperty("奖品图片地址")
     @Column(name = "icon_path")
     private String iconPath;


     @ApiModelProperty("每天最多中奖份数")
     @Column(name = "day_max_use")
     private Integer dayMaxUse;

     @Column(name = "total_stock")
     private Integer totalStock;

     @NotNull(message = "权重|概率不能为null")
     @Column(name = "probability")
     private Double probability;

     @NotNull(message = "奖品设置类型不能null")
     @ApiModelProperty("1：线上 2：现场")
     @Column(name = "type")
     private Integer type;

     @Column(name = "crt_time")
     private Date crtTime;
     @Column(name = "upd_time")
     private Date updTime;
     @Column(name = "goods_id")
     private Integer goodsId;

     @NotNull(message = "奖品类型不能为null")
     @Column(name = "prize_goods_type")
     private Integer prizeGoodsType;
}
