package com.xxfc.platform.campsite.rest.admin;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.campsite.biz.CampsiteTagBiz;
import com.xxfc.platform.campsite.entity.CampsiteTag;
import com.xxfc.platform.campsite.vo.CampsiteTagVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;


/**
 * @author libin
 * @version 1.0
 * @description 营地类型
 * @data 2019/6/17 13:36
 */
@RestController
@RequestMapping("/admin/campsiteTag")
@Api(tags = "后台*营地类型")
public class CampsiteTagAdminController extends BaseController<CampsiteTagBiz,CampsiteTag> {

    @ApiOperation("逻辑删除")
    @Override
    public ObjectRestResponse<CampsiteTag> remove(@PathVariable("id") int id) {
        int effectRows = getBaseBiz().updateCampsiteTagStatus(id);
        if (effectRows>0){
           return ObjectRestResponse.succ();
        }
        return ObjectRestResponse.createDefaultFail();
    }

    @ApiOperation("营地类型的分页")
    @GetMapping("/pages")
    public ObjectRestResponse<CampsiteTagVo> pages(@RequestParam("page") Integer page,@RequestParam("limit") Integer limit){
        PageDataVO<CampsiteTagVo> tagVoPageDataVO = getBaseBiz().findCampsiteTagsPage(page,limit);
        return ObjectRestResponse.succ(tagVoPageDataVO);
    }

    @ApiOperation("筛选状态更改")
    @PutMapping("/searchStatus")
    public ObjectRestResponse<Void> updateIsSearchStatus(@RequestParam("id") Integer id,@RequestParam("status") Integer status){
       int effectRows =  getBaseBiz().updateCampsiteTagIsSearchStatus(id,status);
        if (effectRows>0){
            return ObjectRestResponse.succ();
        }
        return ObjectRestResponse.createDefaultFail();
    }

    @ApiOperation("校验营地类型名称")
    @GetMapping("/exist")
    public ObjectRestResponse<Boolean> checkTagNameExist(@RequestParam(value = "id",required = false) Integer id,@RequestParam("name") String name){
         Boolean exist =  getBaseBiz().checkTagNameExist(id,name==null?"":name.trim());
         return ObjectRestResponse.succ(exist);
    }

}