package com.xxfc.platform.vehicle.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;

/**
 * @author libin
 * @version 1.0
 * @description 车型概况
 * @data 2019/12/24 16:32
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@Table(name = "vehicle_profile_display")
public class VehicleProfileDisplay {
    @Id
    @GeneratedValue(generator = "JDBC")
    @JsonIgnore
    private Integer id;
    /**
     * 省份code
     */
    @Column(name = "province_code")
    private Integer provinceCode;
    /**
     * 省份名
     */
    @Column(name = "province_name")
    private String provinceName;
    /**
     * 车辆数量
     */
    @Column(name = "vehicle_num")
    private Integer vehicleNum;

}
