package com.xxfc.platform.order.rest.background;

import cn.hutool.core.date.DateUtil;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.order.biz.CompanyPerformanceBiz;
import com.xxfc.platform.order.bo.CompanyPerformanceBo;
import com.xxfc.platform.order.pojo.dto.CompanyPerformanceFindDTO;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;

/**
 * @author libin
 * @version 1.0
 * @description 公司业绩查询
 * @data 2019/11/23 14:32
 */
@Slf4j
@Controller
@RequestMapping("/statistics")
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
public class CompanyOrderReceivedStatiscsAdminController {

      private final CompanyPerformanceBiz companyPerformanceBiz;

      @PostMapping("/company_performance")
      @ResponseBody
      public ObjectRestResponse<PageDataVO<CompanyPerformanceBo>> companyPerformance(@RequestBody CompanyPerformanceFindDTO companyPerformanceFindDTO){
           if(companyPerformanceFindDTO.getStartDate() == null && companyPerformanceFindDTO.getEndDate()==null){
               Date date = new Date();
               Date startDate = DateUtil.beginOfMonth(date).toJdkDate();
               Date endDate = DateUtil.endOfMonth(date).toJdkDate();
               companyPerformanceFindDTO.setStartDate(startDate);
               companyPerformanceFindDTO.setEndDate(endDate);
           }
          PageDataVO<CompanyPerformanceBo> dataVO  = companyPerformanceBiz.selectCompanyPerformancePage(companyPerformanceFindDTO);
          return ObjectRestResponse.succ(dataVO);
      }

      @ApiOperation("导出")
      @PostMapping("/export")
      public void exportCompanyPerformance(@RequestBody CompanyPerformanceFindDTO companyPerformanceFindDTO, HttpServletResponse response){

          try {
              companyPerformanceFindDTO.setLimit(null);
              companyPerformanceFindDTO.setPage(null);
              String name = DateTimeFormatter.ofPattern("YYYYMMddHHmmss").format(LocalDateTime.now());
              response.setContentType("application/vnd.ms-excel;charset=utf-8");
              String filename = String.format("%s-company-statistics.xlsx",name);
              response.setHeader("Content-Disposition","attachment;filename="+ new String(filename.getBytes(), "iso8859-1"));
              ServletOutputStream outputStream = response.getOutputStream();
              companyPerformanceBiz.exportOrderReceivedStatisticsData(companyPerformanceFindDTO,outputStream);
              response.setCharacterEncoding("UTF-8");
          }catch (Exception ex){
              log.error("导出数据失败【{}】",ex);
              throw  new BaseException("导出数据失败");
          }
      }
}
