package com.xxfc.platform.app.rest;

import com.ace.cache.annotation.CacheClear;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.app.biz.AppVersionMarkBiz;
import com.xxfc.platform.app.entity.AppVersionMark;
import com.xxfc.platform.app.entity.dto.AppVersionMarkDTO;
import com.xxfc.platform.app.vo.AppVersionMarkQuery;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import tk.mybatis.mapper.entity.Example;

import java.util.List;

/**
 * @program: ace-security
 * @author: zyh
 * @create: 2020-01-10 11:24
 **/
@IgnoreUserToken
@RestController
@Slf4j
@RequestMapping("version/mark")
public class AppVersionMarkController extends BaseController<AppVersionMarkBiz, AppVersionMark> {

    @Autowired
    private AppVersionMarkBiz appVersionMarkBiz;

    /**
     * @Description: 新增APP版本标识
     * @Param: AppVersionMarkDTO appVersionMarkDTO
     * @return:
     * @Author: zyh
     * @Date: 2020/1/10
     */
    @PostMapping("/appMarkVersionAdd")
    @CacheClear
    public ObjectRestResponse addAppVersionMark(@RequestBody AppVersionMarkDTO appVersionMarkDTO) {
        try {
            appVersionMarkBiz.addAppVersionMark(appVersionMarkDTO);
            return ObjectRestResponse.succ();
        } catch (Exception e) {
            log.error("新增失败[{}]", e);
            throw new BaseException("新增失败");
        }
    }

    /**
     * @Description: app版本标识 更新以及删除
     * @Author: zyh
     * @Date: 2020/1/10
     */
    @PostMapping("updAppMark")
    @CacheClear
    public ObjectRestResponse updAppVersionMark(@RequestBody AppVersionMarkDTO appVersionMarkDTO) {
        try {
            appVersionMarkBiz.updAppVersionMark(appVersionMarkDTO);
            return ObjectRestResponse.succ();
        } catch (Exception e) {
            log.error("更新失败[{}]", e);
            throw new BaseException("更新失败");
        }
    }

    /**
     * @Description: 页面展示
     * @Param: AppVersionMarkQuery query 业务需求：暂时没有查询框
     * @return: listJson
     * @Author: zyh
     * @Date: 2020/1/10
     */
    @GetMapping("/findAllByQuery")
    public ObjectRestResponse findAllByQuery(@RequestBody AppVersionMarkQuery query) {
        Example example = new Example(AppVersionMark.class);
        if (StringUtils.isNotBlank(query.getMarkName())) {
            example.createCriteria().andLike("mark", "%" + query.getMarkName() + "%");
        }
        PageHelper.startPage(query.getPage(), query.getLimit());
        List<AppVersionMark> listPage = appVersionMarkBiz.selectByExample(example);
        return ObjectRestResponse.succ(PageInfo.of(listPage));
    }

    /**
     * @Description: 單獨查詢，根据标识
     * @Param: MARK標識
     * @return: list
     * @Author: zyh
     * @Date: 2020/1/10
     */
    @GetMapping("/findVersionAppMark")
    public ObjectRestResponse findAllByQuery(@RequestParam("mark") String mark) {
        return ObjectRestResponse.succ(appVersionMarkBiz.findVersionAppMark(mark));
    }


}
