package com.xxfc.platform.app.biz;


import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.xxfc.platform.app.entity.AppVersionMark;
import com.xxfc.platform.app.entity.dto.AppVersionMarkDTO;
import com.xxfc.platform.app.mapper.AppVersionMarkMapper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import java.sql.Date;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;

import java.util.List;

@Service
@Slf4j
/**
 * @Author: zyh
 * @Date: 2020/1/10
 */
public class AppVersionMarkBiz extends BaseBiz<AppVersionMarkMapper, AppVersionMark> {
    private static final int RANDOM_TWO_LENGTH = 2;
    private static final int CHANGE_UPD_APP_MARK = 1;
    private static final int APP_MARK_IS_DEL = 1;
    private static final int CHANGE_DELETE_APP_MARK = 2;
    private static final int NO_RANDOM_REAPPEAR = 50;

    /**
     * @Description: 新增APP版本标识
     * @Param: AppVersionMarkDTO appVersionMarkDTO
     * @return:
     * @Author: zyh
     * @Date: 2020/1/10
     */
    public ObjectRestResponse addAppVersionMark(AppVersionMarkDTO appVersionMarkDTO) {
        if (StringUtils.isBlank(appVersionMarkDTO.getMarkName()) || StringUtils.isBlank(appVersionMarkDTO.getMarkRemark())) {
            return ObjectRestResponse.createFailedResult(ResultCode.NOTEXIST_CODE, "参数不能为空");
        }
        AppVersionMark appVersionMark = new AppVersionMark();
        appVersionMark.setMark(getMark());
        appVersionMark.setMarkName(appVersionMarkDTO.getMarkName());
        appVersionMark.setMarkRemark(appVersionMarkDTO.getMarkRemark());
        appVersionMark.setIsDel(0);
        insertSelective(appVersionMark);
        return ObjectRestResponse.succ();
    }

    /**
     * @Description: 随机产生，判断数据库是否已经存在
     * @return: 标识
     * @Author: zyh
     * @Date: 2020/1/10
     */
    public String getMark() {
        String mark = "";
        for (int i = 0; i < NO_RANDOM_REAPPEAR; i++) {
            mark = getCharAndNumr3(RANDOM_TWO_LENGTH);
            int count = mapper.queryIsMark(mark);
            if (count == 0) {
                break;
            }
        }
        return mark;
    }

    /**
     * 生成随机数字和字母组合
     *
     * @param length
     * @return
     */
    public static String getCharAndNumr3(int length) {
        StringBuffer valSb = new StringBuffer();
        for (int i = 0; i < length; i++) {
            // 输出字母还是数字
            String charOrNum = Math.round(Math.random()) % 2 == 0 ? "char" : "num";
            if ("char".equalsIgnoreCase(charOrNum)) {
                // 字符串  取得大写字母还是小写字母
                int choice = Math.round(Math.random()) % 2 == 0 ? 65 : 97;
                valSb.append((char) (choice + Math.round(Math.random() * 25)));
            } else if ("num".equalsIgnoreCase(charOrNum)) {
                // 数字
                valSb.append(String.valueOf(Math.round(Math.random() * 9)));
            }
        }
        return valSb.toString();
    }

    /**
     * @Description: app版本标识 更新以及删除
     * @Param: No such property: code for class: Script1
     * @return:
     * @Author: zyh
     * @Date: 2020/1/10
     */
    public ObjectRestResponse updAppVersionMark(AppVersionMarkDTO appVersionMarkDTO) {
        AppVersionMark appVersionMark = new AppVersionMark();
        BeanUtils.copyProperties(appVersionMarkDTO, appVersionMark);
        if (appVersionMarkDTO.getChangeMark() == CHANGE_UPD_APP_MARK) {
            updateSelectiveById(appVersionMark);
        } else if (appVersionMarkDTO.getChangeMark() == CHANGE_DELETE_APP_MARK) {
            appVersionMark.setIsDel(APP_MARK_IS_DEL);
            updateSelectiveById(appVersionMark);
        }
        return ObjectRestResponse.succ();
    }

    /**
     * @Description: 查询页面展示
     * @Param:
     * @return: AppVersionMarkDTO  appVersionMarkDTO
     * @Author: zyh
     * @Date: 2020/1/10
     */
    public List<AppVersionMarkDTO> findVersionAppMark(String mark) {
        List list = mapper.findVersionAppMark(mark);
        return list;
    }

}


