package com.xxfc.platform.uccn.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;
import tk.mybatis.mapper.annotation.KeySql;
import tk.mybatis.mapper.code.IdentityDialect;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.util.Date;

/**
 * 文章实体
 *
 * @author Administrator
 */
@Data
@Table(name = "article")
@ApiModel(value = "文章实体")
public class Article {

    @Id
    @KeySql(dialect = IdentityDialect.MYSQL)
    private Integer id;
    /**
     * 标题
     */
    @Column(name = "title")
    @ApiModelProperty(value = "标题")
    private String title;

    /**
     * 副标题
     */
    @Column(name = "subtitle")
    @ApiModelProperty(value = "副标题")

    private String subtitle;

    /**
     * 文章摘要
     */
    @Column(name = "epitome")
    @ApiModelProperty(value = "文章摘要")
    private String epitome;

    /**
     * 正文
     */
    @Column(name = "text")
    @ApiModelProperty(value = "正文")
    private String text;

    /**
     * 图片url,以逗号分割
     */
    @Column(name = "picture")
    @ApiModelProperty(value = "图片url,以逗号分割")
    private String picture;

    /**
     * 作者
     */
    @Column(name = "author")
    @ApiModelProperty(value = "作者")
    private Integer author;

    /**
     * 发布人
     */
    @Column(name = "publisher")
    @ApiModelProperty(value = "发布人")
    private Integer publisher;

    /**
     * 封面图
     */
    @Column(name = "cover_image")
    @ApiModelProperty(value = "封面图")
    private Integer coverImage;

    /**
     * 权重
     */
    @Column(name = "weight")
    @ApiModelProperty(value = "权重")
    private Integer weight;

    /**
     * 是否删除:0-否,1-是
     */
    @Column(name = "is_del")
    @ApiModelProperty(value = "是否删除:0-否,1-是")
    private Integer isDel;

    /**
     * 是否上下架:0-否,1-是
     */
    @Column(name = "status")
    @ApiModelProperty(value = "是否上下架:0-否,1-是")
    private Integer status;

    /**
     * 创建时间
     */
    @Column(name = "cre_time")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建时间")
    private Date creTime;

    /**
     * 修改时间
     */
    @Column(name = "upd_time")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "修改时间")
    private Date updTime;

    /**
     * 上架时间
     */
    @Column(name = "add_time")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "上架时间")
    private Date addTime;

}
