package com.xxfc.platform.campsite.feign;


import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.vo.GoodDataVO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * Created by ace on 2017/9/15.
 */
//@FeignClient(value = "${auth.serviceId}",configuration = {})
@FeignClient("xx-campsite")
public interface CampsiteFeign {

    @ApiOperation("首页营地列表")
    @GetMapping(value = "/campsiteShop/app/shopList")
    public List<GoodDataVO> goodList(@RequestParam(value = "page", defaultValue = "1") Integer page,
                                     @RequestParam(value = "limit",defaultValue = "4") Integer limit);
    @GetMapping(value = "/campsiteShop/app/unauth/findRandomVehicle")
    public ObjectRestResponse findRandomVehicle(@RequestParam(value = "number")Integer number);
}
