package com.github.wxiaoqi.security.admin.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * 支付宝账号表
 */
@Table(name = "app_user_alipay")
@Data
public class AppUserAlipay {
    @Id
    @GeneratedValue(generator = "JDBC")//此处加上注解
    private Integer id;

    @ApiModelProperty("用户id")
    @Column(name = "user_id")
    private Integer userId;

    @ApiModelProperty("支付宝账号")
    @Column(name = "tx_alipay")
    private String txAlipay;

    @ApiModelProperty("0-否；1-是")
    @Column(name = "is_default")
    private Integer isDefault;

    @ApiModelProperty("创建时间")
    @Column(name = "crt_time")
    private Long crtTime;

    @ApiModelProperty("是否删除；0-正常；1-删除")
    @Column(name = "is_del")
    private Integer isDel;




}