package com.xxfc.platform.order.pojo.dto;

import com.github.wxiaoqi.security.common.vo.PageParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/11/23 14:36
 */
@Data
@Builder(toBuilder = true)
@NoArgsConstructor
@AllArgsConstructor
public class CompanyPerformanceFindDTO extends PageParam {

    private Date startDate;

    private Date endDate;

    @ApiModelProperty("统计方式 1:日 2:周 3：月")
    @NotNull(message = "统计方式不能为null")
    private Integer statisticalWay;
    private String companyName;
    private Integer companyId;

    private long startIndex;

    private long endInex;

    public long getStartIndex() {
        return getPage()==null?0:getPage()==0?0:(getPage()-1)*getLimit();
    }

    public long getEndInex() {
        return getLimit()==null?20:getLimit()==0?20:getLimit();
    }
}
