package com.xxfc.platform.order.contant.enumerate;


import org.assertj.core.util.Lists;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum DeductionTypeEnum {
    //账款类型 1--违约金；2--消费金额；3--赔偿金（定损）；4--违章相关
    VIOLATE_CANCEL(101, "提前取消违约金"),
    VIOLATE_ADVANCE(102, "提前还车违约金"),
    VIOLATE_DELAY(103, "延迟还车违约金"),
    VIOLATE_CHANGE_C(104, "更换还车公司费用"),
    CONSUME(201, "消费金额"),
    DAMAGES(301, "赔偿金（定损）"),
    VIOLATE_TRAFFIC_DEDUCT(401, "违章扣款"),
    VIOLATE_TRAFFIC_KEEP(402, "违章扣款保留金"),
    ;
    /**
     * 编码
     */
    private Integer code;
    /**
     * 类型描述
     */
    private String desc;
    /**
     * 违约相关code
     */
    public static List<Integer> lateFeeCode;
    /**
     * 定损相关code
     */
    public static List<Integer> lossSpecifiedCode;
    /**
     * 违章相关code
     */
    public static List<Integer> breakRulesRegulationCode;
    /**
     *消费金额相关code
     */
    public static List<Integer> consumerCode;

    private static Map<Integer, String> codeAndDesc = new HashMap<Integer, String>();

    static {
        for (DeductionTypeEnum enumE : DeductionTypeEnum.values()) {
            codeAndDesc.put(enumE.getCode(), enumE.getDesc());
        }

        lateFeeCode = Lists.newArrayList(VIOLATE_CANCEL.getCode(),
                VIOLATE_ADVANCE.getCode(),
                VIOLATE_DELAY.getCode(),
                VIOLATE_CHANGE_C.getCode());


        lossSpecifiedCode = Lists.newArrayList(DAMAGES.getCode());

        breakRulesRegulationCode = Lists.newArrayList(
                VIOLATE_TRAFFIC_DEDUCT.getCode()
        );

        consumerCode = Lists.newArrayList(CONSUME.getCode());
    }

    DeductionTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static Boolean exists(Integer code) {
        return codeAndDesc.containsKey(code);
    }
}