package com.github.wxiaoqi.security.admin.biz;

import com.github.wxiaoqi.security.admin.constant.WalletDetailTypeEnum;
import com.github.wxiaoqi.security.admin.dto.PersonalConsumptionDTO;
import com.github.wxiaoqi.security.admin.dto.WalletDetailFindDTO;
import com.github.wxiaoqi.security.admin.dto.WalletDetailListDTO;
import com.github.wxiaoqi.security.admin.entity.MyWalletDetail;
import com.github.wxiaoqi.security.admin.mapper.MyWalletDetailMapper;
import com.github.wxiaoqi.security.admin.vo.WalletDetailAdminVo;
import com.github.wxiaoqi.security.admin.vo.WalletDetailPageVo;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import tk.mybatis.mapper.entity.Example;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/12 9:18
 */
@Transactional
@Service
@Data
public class MyWalletDetailBiz extends BaseBiz<MyWalletDetailMapper, MyWalletDetail> implements InitializingBean {

     private Map<Integer,WalletDetailTypeEnum> typeEnumMap;


 public PageDataVO<WalletDetailPageVo> findWalletDetailPage(Integer userId,Integer pageNo,Integer pageSize){

     PageDataVO<WalletDetailPageVo> walletDetailPageVo = new PageDataVO<>();
     Example example = new Example(MyWalletDetail.class);
     Example.Criteria criteria = example.createCriteria();
     criteria.andEqualTo("userId",userId);
     example.setOrderByClause("crt_time DESC");

     PageDataVO<MyWalletDetail> walletDetailPageVoPageDataVO = PageDataVO.pageInfo(pageNo, pageSize, () -> mapper.selectByExample(example));
     List<MyWalletDetail> walletDetails = walletDetailPageVoPageDataVO.getData();
     if (CollectionUtils.isEmpty(walletDetails)){
         return walletDetailPageVo;
     }
     List<WalletDetailPageVo> walletDetailPageVoList = new ArrayList<>();
     WalletDetailPageVo walletDetail;
     for (MyWalletDetail walletDetailPage : walletDetails) {
         walletDetail = new WalletDetailPageVo();
         BeanUtils.copyProperties(walletDetailPage,walletDetail);
         walletDetail.setDesc(typeEnumMap.get(walletDetail.getSource()).getDesc());
         walletDetailPageVoList.add(walletDetail);
     }
     walletDetailPageVo.setTotalPage(walletDetailPageVoPageDataVO.getTotalPage());
     walletDetailPageVo.setTotalCount(walletDetailPageVoPageDataVO.getTotalCount());
     walletDetailPageVo.setPageSize(walletDetailPageVoPageDataVO.getPageSize());
     walletDetailPageVo.setPageNum(walletDetailPageVoPageDataVO.getPageNum());
     walletDetailPageVo.setData(walletDetailPageVoList);
     return walletDetailPageVo;
 }

 public PageDataVO<WalletDetailAdminVo> findWalletDetailPage(WalletDetailFindDTO walletDetailFindDTO){
        PageDataVO<WalletDetailAdminVo> pageDataVO = new PageDataVO<>();

        PageDataVO<WalletDetailListDTO> walletDetailPage = PageDataVO.pageInfo(walletDetailFindDTO.getPage(),
                            walletDetailFindDTO.getLimit(),
                            ()->mapper.findWalletDetailsByUserNameOrPhoneOrsourceType(walletDetailFindDTO.getUsername(),
                                    walletDetailFindDTO.getPhone(),
                                    walletDetailFindDTO.getSource(),
                                    walletDetailFindDTO.getStartTime(),
                                    walletDetailFindDTO.getEndTime()));
     List<WalletDetailListDTO> detailListDTOS = walletDetailPage.getData();
     if (CollectionUtils.isEmpty(detailListDTOS)){
         return pageDataVO;
     }


     List<WalletDetailAdminVo> walletDetailAdminVos = new ArrayList<>();
     WalletDetailAdminVo walletDetailAdminVo;
     for (WalletDetailListDTO detailListDTO : detailListDTOS) {
         walletDetailAdminVo = new WalletDetailAdminVo();
         BeanUtils.copyProperties(detailListDTO,walletDetailAdminVo);
         walletDetailAdminVo.setUsername(StringUtils.isEmpty(detailListDTO.getRealname())?detailListDTO.getNickname():detailListDTO.getRealname());
         walletDetailAdminVos.add(walletDetailAdminVo);
         walletDetailAdminVo.setSourceName(StringUtils.isEmpty(detailListDTO.getTitle())?detailListDTO.getActivityName():detailListDTO.getTitle());
     }
     walletDetailAdminVos.sort(Comparator.comparing(WalletDetailAdminVo::getCrtTime).reversed());
     pageDataVO.setPageNum(walletDetailFindDTO.getPage());
     pageDataVO.setPageSize(walletDetailFindDTO.getLimit());
     pageDataVO.setTotalCount(walletDetailPage.getTotalCount());
     pageDataVO.setTotalPage(walletDetailPage.getTotalPage());
     pageDataVO.setData(walletDetailAdminVos);
     return pageDataVO;
 }

    public Map<Integer, BigDecimal> finduserIdAndPersonalTotalConsumptionMapByUserIds(List<Integer> userIds) {
        List<PersonalConsumptionDTO> personalConsumptions = mapper.findpersonalConsumptionsByUserIds(userIds);
        Map<Integer, BigDecimal> userIdAndPersonalConsumptionMap = personalConsumptions.stream().collect(Collectors.toMap(PersonalConsumptionDTO::getUserId, PersonalConsumptionDTO::getTotalConsumption));
        return userIdAndPersonalConsumptionMap;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        typeEnumMap = EnumSet.allOf(WalletDetailTypeEnum.class).stream().collect(Collectors.toMap(WalletDetailTypeEnum::getCode, Function.identity()));
    }
}
