package com.xxfc.platform.vehicle.rest;

import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.common.annotation.BeanValid;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.vehicle.biz.VehicleUserScoreBiz;
import com.xxfc.platform.vehicle.entity.VehicleUserScore;
import com.xxfc.platform.vehicle.pojo.dto.VehicleUserScoreDTO;
import com.xxfc.platform.vehicle.pojo.vo.VehicleUserScoreVo;
import org.springframework.web.bind.annotation.*;

/**
 * @author libin
 * @version 1.0
 * @description 评价
 * @data 2019/6/18 15:32
 */
@RestController
@RequestMapping("vehicleUserScore")
public class VehicleUserScoreController extends BaseController<VehicleUserScoreBiz, VehicleUserScore> {

    /**
     * 保存评论
     * @param vehicleUserScoreDTO
     * @param appUserDTO
     * @return
     */
    @PostMapping("/score")
     public ObjectRestResponse<Void> saveVehicleUserScore(@RequestBody @BeanValid VehicleUserScoreDTO vehicleUserScoreDTO, AppUserDTO appUserDTO){
         int effectRows = getBaseBiz().saveVehicleUserScore(vehicleUserScoreDTO,appUserDTO);
         if (effectRows>0){
            return ObjectRestResponse.succ();
         }
         return ObjectRestResponse.createDefaultFail();
     }
    /**
     * 根据车型查询评论列表  根据评分时间排序
     *
     * @param modelId
     * @param pageNo
     * @param pageSize
     * @return
     */
    @GetMapping("/app/unauth/scores")
    public ObjectRestResponse<PageDataVO<VehicleUserScoreVo>> findVehicleUserScorePageByModelId(@RequestParam("modelId") Integer modelId,
                                                                                                @RequestParam(value = "pageNo",required = false,defaultValue = "1")Integer pageNo,
                                                                                                @RequestParam(value = "pageSize",required = false,defaultValue = "10") Integer pageSize) {
        PageDataVO<VehicleUserScoreVo> pageDataVO = getBaseBiz().findVehicleUserScorePageByModelId(modelId,pageNo,pageSize);
        return ObjectRestResponse.succ(pageDataVO);
    }

    /**
     * 根据订单id查询评价详情
     * @param orderId
     * @return
     */
    @GetMapping("/score/order/{orderId}")
    public ObjectRestResponse findVehicleUserScoreDetailByOrderId(@PathVariable("orderId") Integer orderId){
        VehicleUserScoreVo vehicleUserScoreVo = getBaseBiz().findVehicleUserScoreDetailByOrderId(orderId);
        return ObjectRestResponse.succ(vehicleUserScoreVo);
    }
}