package com.xxfc.platform.uccn.biz;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.github.wxiaoqi.security.admin.feign.dto.UserDTO;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.util.RandomUtil;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.uccn.dto.SummitActivityFindDTO;
import com.xxfc.platform.uccn.dto.SummitActivitySaveDTO;
import com.xxfc.platform.uccn.entity.SummitActivity;
import com.xxfc.platform.uccn.mapper.SummitActivityMapper;
import com.xxfc.platform.uccn.vo.SummitActivityAdminVo;
import com.xxfc.platform.uccn.vo.SummitActivityDetailVo;
import com.xxfc.platform.uccn.vo.SummitActivityVo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

import java.time.Instant;
import java.util.*;

/**
 * 峰会活动
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-08-26 15:25:32
 */
@Service
public class SummitActivityBiz extends BaseBiz<SummitActivityMapper, SummitActivity> {


    public List<SummitActivityVo> findSummitActivityForHomePage(Integer limit, Integer location) {
        Example example = new Example(SummitActivity.class);
        example.setOrderByClause("rank");
        Example.Criteria criteria = example.createCriteria();
        //未删除
        criteria.andEqualTo("isDel", 0);
        //是首页展示
        criteria.andEqualTo("isHomePage", 1);
        //已发布
        criteria.andEqualTo("isPublish", 1);
        //活动未下架
        criteria.andEqualTo("isShow", 1);
        //位置
        criteria.andIn("location", Arrays.asList(location, 0));

        PageDataVO<SummitActivity> dataVO = PageDataVO.pageInfo(1, limit, () -> mapper.selectByExample(example));
        List<SummitActivity> summitActivities = dataVO.getData();
        if (CollectionUtils.isEmpty(summitActivities)) {
            return Collections.EMPTY_LIST;
        }
        return JSON.parseObject(JSON.toJSONString(summitActivities), new TypeReference<List<SummitActivityVo>>() {
        });
    }

    public SummitActivityDetailVo findSummitActivityDetailById(Integer id) {
        SummitActivityDetailVo summitActivityDetailVo = new SummitActivityDetailVo();
        SummitActivity summitActivity = mapper.selectByPrimaryKey(id);
        BeanUtils.copyProperties(summitActivity, summitActivityDetailVo);
        return summitActivityDetailVo;
    }

    public PageDataVO<SummitActivityAdminVo> listSummitActivityWithPage(SummitActivityFindDTO summitActivityFindDTO) {
        PageDataVO<SummitActivityAdminVo> activityAdminVoPageDataVO = new PageDataVO<>();
        Example example = new Example(SummitActivity.class);
        example.setOrderByClause("crt_time");
        Example.Criteria criteria = example.createCriteria();
        if (StringUtils.isNotEmpty(summitActivityFindDTO.getTitle())) {
            criteria.andLike("title", String.format("%%%s%%", summitActivityFindDTO.getTitle()));
        }
        criteria.andEqualTo("isDel", 0);

        PageDataVO<SummitActivity> pageDataVO = PageDataVO.pageInfo(summitActivityFindDTO.getPage(), summitActivityFindDTO.getLimit(), () -> mapper.selectByExample(example));
        List<SummitActivity> data = pageDataVO.getData();
        if (CollectionUtils.isEmpty(data)) {
            return activityAdminVoPageDataVO;
        }

        List<SummitActivityAdminVo> summitActivityAdminVos = new ArrayList<>();
        SummitActivityAdminVo summitActivityAdminVo;
        for (SummitActivity summitActivity : data) {
            summitActivityAdminVo = new SummitActivityAdminVo();
            BeanUtils.copyProperties(summitActivity, summitActivityAdminVo);
            summitActivityAdminVos.add(summitActivityAdminVo);
        }
        activityAdminVoPageDataVO.setTotalCount(pageDataVO.getTotalCount());
        activityAdminVoPageDataVO.setTotalPage(pageDataVO.getTotalPage());
        activityAdminVoPageDataVO.setPageNum(pageDataVO.getPageNum());
        activityAdminVoPageDataVO.setPageSize(pageDataVO.getPageSize());
        activityAdminVoPageDataVO.setData(summitActivityAdminVos);
        return activityAdminVoPageDataVO;
    }

    public void saveSummitActivity(SummitActivitySaveDTO summitActivitySaveDTO, UserDTO userDTO) {
        SummitActivity summitActivity = new SummitActivity();
        if (Objects.isNull(summitActivitySaveDTO.getId())) {
            BeanUtils.copyProperties(summitActivitySaveDTO, summitActivity);
            summitActivity.setCrtName(userDTO.getUsername());
            summitActivity.setCrtUser(userDTO.getId());
            summitActivity.setCrtTime(Instant.now().toEpochMilli());
            mapper.insertSelective(summitActivity);
        } else {
            BeanUtils.copyProperties(summitActivitySaveDTO, summitActivity);
            summitActivity.setUpdTime(Instant.now().toEpochMilli());
            mapper.updateByPrimaryKeySelective(summitActivity);
        }
    }

    public void publishSummitActivityById(Integer id, Integer state) {
        SummitActivity summitActivity = new SummitActivity();
        summitActivity.setIsPublish(state);
        summitActivity.setUpdTime(Instant.now().toEpochMilli());
        summitActivity.setId(id);
        mapper.updateByPrimaryKeySelective(summitActivity);
    }

    public void soldOutSummitAcitivityById(Integer id, Integer state) {
        SummitActivity summitActivity = new SummitActivity();
        summitActivity.setIsShow(state);
        summitActivity.setId(id);
        summitActivity.setUpdTime(Instant.now().toEpochMilli());
        mapper.updateByPrimaryKeySelective(summitActivity);
    }

    public void setShowOnHomePageById(Integer id, Integer state) {
        SummitActivity summitActivity = new SummitActivity();
        summitActivity.setIsHomePage(state);
        summitActivity.setId(id);
        summitActivity.setUpdTime(Instant.now().toEpochMilli());
        mapper.updateByPrimaryKeySelective(summitActivity);
    }

    public void setRegSateWithSummitActivityById(Integer id, Integer state) {
        SummitActivity summitActivity = new SummitActivity();
        summitActivity.setIsOpenReg(state);
        summitActivity.setId(id);
        summitActivity.setUpdTime(Instant.now().toEpochMilli());
        mapper.updateByPrimaryKeySelective(summitActivity);
    }

    public void deleteSummitActivityById(Integer id) {
        SummitActivity summitActivity = new SummitActivity();
        summitActivity.setIsDel(1);
        summitActivity.setId(id);
        summitActivity.setUpdTime(Instant.now().toEpochMilli());
        mapper.updateByPrimaryKeySelective(summitActivity);
    }

    public SummitActivitySaveDTO selectSummitActivityById(Integer id) {
        SummitActivitySaveDTO summitActivitySaveDTO = new SummitActivitySaveDTO();
        SummitActivity summitActivity = mapper.selectByPrimaryKey(id);
        BeanUtils.copyProperties(summitActivity, summitActivitySaveDTO);
        return summitActivitySaveDTO;
    }

    /**
     * 更改排序
     *
     * @param id
     * @param rank
     */
    public void updateSummitActivityRankById(Integer id, Integer rank) {
        SummitActivity summitActivity = new SummitActivity();
        summitActivity.setId(id);
        summitActivity.setRank(rank);
        summitActivity.setUpdTime(Instant.now().toEpochMilli());
        mapper.updateByPrimaryKeySelective(summitActivity);
    }

    public List<SummitActivityVo> getHostWithSummitActivity(Integer num, Integer location) {
        List<SummitActivityVo> summitActivityVos = new ArrayList<>();
        Example example = new Example(SummitActivity.class);
        example.setOrderByClause("crt_time DESC");
        Example.Criteria criteria = example.createCriteria();
        //未删除
        criteria.andEqualTo("isDel", 0);
        //已发布
        criteria.andEqualTo("isPublish", 1);
        //活动未下架
        criteria.andEqualTo("isShow", 1);
        //位置
        criteria.andIn("location", Arrays.asList(location, 0));
    //    criteria.andGreaterThan("endTime", Instant.now().toEpochMilli());

        List<SummitActivity> summitActivities = mapper.selectByExample(example);

        if (CollectionUtils.isNotEmpty(summitActivities)) {
            SummitActivityVo summitActivityVo;
            if (summitActivities.size() <= num) {
                for (SummitActivity summitActivity : summitActivities) {
                    summitActivityVo = new SummitActivityVo();
                    BeanUtils.copyProperties(summitActivity,summitActivityVo);
                    summitActivityVos.add(summitActivityVo);
                }
            } else {
                Set<Integer> resultSet = new HashSet<>();
                RandomUtil.randomSet(summitActivities.size(), num, resultSet, num);
                for (Integer i : resultSet) {
                    summitActivityVo = new SummitActivityVo();
                    SummitActivity summitActivity = summitActivities.get(i);
                    BeanUtils.copyProperties(summitActivity,summitActivityVo);
                    summitActivityVos.add(summitActivityVo);
                }
            }
        }
        return summitActivityVos;
    }

    public PageDataVO<SummitActivityVo> findSummitActivityWithPage(Integer page, Integer limit, Integer location,String title) {
        PageDataVO<SummitActivityVo> dataVO = new PageDataVO<>();

        Example example = new Example(SummitActivity.class);
        example.setOrderByClause("rank ASC ,start_time DESC");
        Example.Criteria criteria = example.createCriteria();
        //未删除
        criteria.andEqualTo("isDel", 0);
        //已发布
        criteria.andEqualTo("isPublish", 1);
        //活动未下架
        criteria.andEqualTo("isShow", 1);
        //位置
        criteria.andIn("location", Arrays.asList(location, 0));
        //标题
         if (StringUtils.isNotEmpty(title)){
             criteria.andLike("title",String.format("%%%s%%",title.trim()));
         }
        PageDataVO<SummitActivity> summitActivityPageDataVO = PageDataVO.pageInfo(page, limit, () -> mapper.selectByExample(example));
        List<SummitActivity> summitActivities = summitActivityPageDataVO.getData();
        if (CollectionUtils.isEmpty(summitActivities)){
            dataVO.setPageNum(page);
            dataVO.setPageSize(limit);
            dataVO.setData(Collections.EMPTY_LIST);
            return dataVO;
        }
        List<SummitActivityVo> summitActivityVos = new ArrayList<>();
        SummitActivityVo summitActivityVo;
        for (SummitActivity summitActivity : summitActivities) {
            summitActivityVo = new SummitActivityVo();
            BeanUtils.copyProperties(summitActivity,summitActivityVo);
            summitActivityVos.add(summitActivityVo);
        }

        dataVO.setData(summitActivityVos);
        dataVO.setPageNum(summitActivityPageDataVO.getPageNum());
        dataVO.setPageSize(summitActivityPageDataVO.getPageSize());
        dataVO.setTotalCount(summitActivityPageDataVO.getTotalCount());
        dataVO.setTotalPage(summitActivityPageDataVO.getTotalPage());
        return dataVO;
    }
}