package com.xxfc.platform.order.rest.background;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.order.biz.MemberStatisticsBiz;
import com.xxfc.platform.order.pojo.bo.MemberStatisticsPageBo;
import com.xxfc.platform.order.pojo.dto.MemberStatisticsFindDTO;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2020/1/6 12:34
 */
@Controller
@RequestMapping("/admin/member/statistics")
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
public class MemberStatisticsAdminController {
    private final MemberStatisticsBiz memberStatisticsBiz;

    @PostMapping("/page")
    @ResponseBody
    public ObjectRestResponse<MemberStatisticsPageBo> findMemberStatisticsWithPage(@RequestBody MemberStatisticsFindDTO memberStatisticsFindDTO){
        MemberStatisticsPageBo memberStatisticsPageBo =  memberStatisticsBiz.findMemberStatisticsWithPage(memberStatisticsFindDTO);
       return ObjectRestResponse.succ(memberStatisticsPageBo);
    }
}
