package com.xxfc.platform.order.rest.background;

import com.github.wxiaoqi.security.admin.entity.BaseUserMemberLevel;
import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.dto.UserDTO;
import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.xxfc.platform.order.biz.DailyMembersOrderStatisticsBiz;
import com.xxfc.platform.order.biz.DailyTravelOrderStatisticsBiz;
import com.xxfc.platform.order.biz.DailyVehicleOrderStatisticsBiz;
import com.xxfc.platform.order.biz.OrderStatisticsBiz;
import com.xxfc.platform.order.entity.OrderStatistics;
import com.xxfc.platform.order.pojo.HomePageOrderData;
import com.xxfc.platform.order.pojo.OrderQuery;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author Administrator
 */
@RestController
@RequestMapping("orderStatistics")
@Api(description = "每月总的订单统计")
public class OrderStatisticsController extends BaseController<OrderStatisticsBiz, OrderStatistics> {
    @Autowired
    private UserFeign userFeign;

    @Autowired
    private UserAuthConfig userAuthConfig;
    /**
     * 租车订单
     */
    private final Integer TYPE_VEHICLE = 1;

    /**
     * 旅游订单
     */
    private final Integer TYPE_TOUR = 2;

    /**
     * 购买会员订单
     */
    private final Integer TYPE_MEMBER = 3;

    /**
     * 月总数据
     */
    private final Integer TYPE_TOTAL = 4;

    /**
     * 数据权限
     */
    private final Integer DATA_AUTHORITY = 1;

    @Autowired
    private DailyVehicleOrderStatisticsBiz vehicleBiz;


    @Autowired
    private DailyTravelOrderStatisticsBiz TravelBiz;

    @Autowired
    private DailyMembersOrderStatisticsBiz membersBiz;


    @ApiOperation("获取订单统计数据")
    @GetMapping("/findAll/{type}")
    public ObjectRestResponse findAll(@PathVariable Integer type) {


        try {
            ObjectRestResponse<UserDTO> userDTOObjectRestResponse
                    = userFeign.userinfoByToken(userAuthConfig.getToken(getRequest()));

            if (userDTOObjectRestResponse == null || userDTOObjectRestResponse.getData() == null) {
                throw new BaseException("请登录!");
            }
            UserDTO user = userDTOObjectRestResponse.getData();

            Integer companyId = user.getCompanyId();
            if (DATA_AUTHORITY.equals(user.getDataAll())) {
                companyId = null;
            }

            if (TYPE_VEHICLE.equals(type)) {
                OrderStatistics vehicle = vehicleBiz.findAll(companyId);
                return ObjectRestResponse.succ(new HomePageOrderData() {{
                    setTotalOrders(vehicle.getTotalGmv().subtract(vehicle.getTotalReturnGmv()));
                    setAdditionalIndemnity(vehicle.getTotalCompensation()
                            .add(vehicle.getTotalForfeit())
                            .add(vehicle.getTotalDefaultMoney())
                            .add(vehicle.getTotalExpenditure().subtract(vehicle.getTotalGmv().subtract(vehicle.getTotalReturnGmv())))
                    );
                }});
            }
            if (TYPE_TOUR.equals(type)) {
                OrderStatistics tour = TravelBiz.findAll(companyId);
                return ObjectRestResponse.succ(new HomePageOrderData() {{
                    setTotalOrders(tour.getTotalGmv().subtract(tour.getTotalReturnGmv()));
                    setAdditionalIndemnity(tour.getTotalDefaultMoney());
                }});
            }
            if (TYPE_MEMBER.equals(type)) {
                OrderStatistics member = membersBiz.findAll(companyId);
                return ObjectRestResponse.succ(new HomePageOrderData() {{
                    setTotalOrders(member.getTotalGmv());

                }});
            }

            if (TYPE_TOTAL.equals(type)) {
                return ObjectRestResponse.succ(baseBiz.getTotalOrder(companyId));
            }

            return ObjectRestResponse.createFailedResult(ResultCode.FAILED_CODE, "参数错误!");
        } catch (Exception e) {
            e.printStackTrace();
            return ObjectRestResponse.createDefaultFail();
        }

    }

    @GetMapping("/order")
    public ObjectRestResponse getMemberOrderStatisticsData(@RequestBody OrderQuery query) {

        //获取会员等级信息
        List<BaseUserMemberLevel> memberLevels = userFeign.levels();
        //获取会员订单统计信息
        baseBiz.getMemberOrderStatistics(memberLevels,query);

        return ObjectRestResponse.succ();

    }


}
