package com.xxfc.platform.order.biz;

import cn.hutool.core.collection.CollectionUtil;
import com.github.wxiaoqi.security.admin.entity.BaseUserMemberLevel;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.xxfc.platform.order.contant.enumerate.OrderInquiryType;
import com.xxfc.platform.order.entity.MembersOrder;
import com.xxfc.platform.order.entity.OrderStatistics;
import com.xxfc.platform.order.mapper.OrderStatisticsMapper;
import com.xxfc.platform.order.pojo.HomePageOrderData;
import com.xxfc.platform.order.pojo.Member;
import com.xxfc.platform.order.pojo.MembersOrderDto;
import com.xxfc.platform.order.pojo.OrderQuery;
import org.assertj.core.util.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;


/**
 * @author Administrator
 */
@Service
public class OrderStatisticsBiz extends BaseBiz<OrderStatisticsMapper, OrderStatistics> {
    @Autowired
    private DailyVehicleOrderStatisticsBiz vehicleBiz;


    @Autowired
    private DailyTravelOrderStatisticsBiz TravelBiz;

    @Autowired
    private DailyMembersOrderStatisticsBiz membersBiz;

    public HomePageOrderData getTotalOrder(Integer companyId) {
        HomePageOrderData result = new HomePageOrderData();
        ArrayList<HomePageOrderData> orderStatistics = new ArrayList<>();

        OrderStatistics vehicle = vehicleBiz.findAll(companyId);
        if (vehicle != null) {
            HomePageOrderData data = new HomePageOrderData() {{
                setTotalOrders(vehicle.getTotalGmv().subtract(vehicle.getTotalReturnGmv()));
                setAdditionalIndemnity(vehicle.getTotalCompensation()
                        .add(vehicle.getTotalForfeit())
                        .add(vehicle.getTotalDefaultMoney())
                        .add(vehicle.getTotalExpenditure().subtract(vehicle.getTotalGmv().subtract(vehicle.getTotalReturnGmv())))
                );
            }};
            orderStatistics.add(data);
        }
        OrderStatistics tour = TravelBiz.findAll(companyId);

        if (vehicle != null) {
            HomePageOrderData data = new HomePageOrderData() {{
                setTotalOrders(tour.getTotalGmv().subtract(tour.getTotalReturnGmv()));
                setAdditionalIndemnity(tour.getTotalDefaultMoney());
            }};
            orderStatistics.add(data);
        }
        OrderStatistics member = membersBiz.findAll(companyId);
        if (vehicle != null) {
            HomePageOrderData data = new HomePageOrderData() {{
                setTotalOrders(member.getTotalGmv());

            }};
            orderStatistics.add(data);
        }




        result.setTotalOrders(orderStatistics.stream().map(HomePageOrderData::getTotalOrders).filter(o-> Objects.nonNull(o)).reduce(BigDecimal.ZERO, BigDecimal::add));

        result.setTotalOutstandingDeposit(orderStatistics.stream().map(HomePageOrderData::getTotalOutstandingDeposit).filter(o-> Objects.nonNull(o)).reduce(BigDecimal.ZERO, BigDecimal::add));

        result.setAdditionalIndemnity(orderStatistics.stream().map(HomePageOrderData::getAdditionalIndemnity).filter(o-> Objects.nonNull(o)).reduce(BigDecimal.ZERO, BigDecimal::add));

        return result;
    }

    public List<MembersOrderDto> getMemberOrderStatistics(List<BaseUserMemberLevel> memberLevels, OrderQuery query) {
        List<MembersOrder> membersOrderList = membersBiz.getMemberOrderStatistics(query);

        //按每天分类
        if (CollectionUtil.isEmpty(membersOrderList)) {
            return Lists.newArrayList();
        }
        //按每天分类
        if (CollectionUtil.isEmpty(memberLevels)) {
             throw new BaseException("获取不到会员信息");
        }
        //获取会员等级对应的名称
        HashMap<Integer, String> map = Maps.newHashMap();
        for (BaseUserMemberLevel memberLevel : memberLevels) {
            map.put(memberLevel.getLevel(),memberLevel.getName());
        }
        //按查询条件获取统计信息
        if (OrderInquiryType.DAY.getCode().equals(query.getType())) {
            ArrayList<MembersOrderDto> arrayList = Lists.newArrayList();
            for (MembersOrder mb : membersOrderList) {
                MembersOrderDto mbdto = new MembersOrderDto();
                mbdto.setTimeSlot(mb.getPeriod());
                BigDecimal totalPayment = mbdto.getTotalPayment();
                List<Member> members = mb.getMembers();
                if (CollectionUtil.isNotEmpty(members)) {
                    mbdto.setMembers(members);
                    for (Member member : members) {
                        member.setMemberName(map.get(member.getLevel()));
                        totalPayment=totalPayment.add(member.getAmount());
                    }
                }

            }
          return arrayList;
        }
        if (OrderInquiryType.WEEK.getCode().equals(query.getType())){
            ArrayList<MembersOrderDto> arrayList = Lists.newArrayList();
            for (int i = 0; i < membersOrderList.size(); i++) {

            }

        }



        return null;

    }
}
