package com.xxfc.platform.summit.biz;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.summit.entity.Activity;
import com.xxfc.platform.summit.mapper.ActivityMapper;
import com.xxfc.platform.summit.pojo.AccessType;
import com.xxfc.platform.summit.pojo.ActivityQuery;
import com.xxfc.platform.summit.pojo.SummitStatus;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import tk.mybatis.mapper.entity.Example;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Administrator
 */
@Service
public class ActivityBiz extends BaseBiz<ActivityMapper, Activity> {

    @Value("${wx.qdLimts}")
    private BigDecimal qdLimts;

    /**
     * 未删除
     */
    private Integer NOT_DELETE = 0;
    private Activity activity;
    /**
     * 已发布
     */
    private Integer PUBLISHED = 1;

    public Object getList(ActivityQuery query) {

//        Example exa = new Example(Activity.class);
//        Example.Criteria criteria = exa.createCriteria();
//        criteria.andEqualTo("isDel", NOT_DELETE);
//        if (StringUtils.isNotBlank(query.getTitle())) {
//            criteria.andLike("title", String.format("%%%s%%", query.getTitle().trim()));
//        }
//        if (query.getStartTime() != null) {
//            criteria.andLike("startTime", query.getStartTime() / (1000 * 60 * 60) + "%");
//        }
//        if (query.getStatus() != null) {
//            criteria.andEqualTo("status", query.getStatus());
//            switch (query.getStatus()) {
//                case 1:
//
//                     criteria.orLessThan("startTime", System.currentTimeMillis());
//                     break;
//                case 2:
//                    criteria.orBetween("startTime", System.currentTimeMillis(),"endTime");
//                    break;
//                case 3:
//                    criteria.orGreaterThan("endTime", System.currentTimeMillis());
//                    break;
//                default:
//                    throw new IllegalStateException("Unexpected value: " + query.getStatus());
//            }
//        }
//
//        if (query.getType() != null && AccessType.PUBLIC.getCode().equals(query.getType())) {
//            criteria.andEqualTo("isPublish", PUBLISHED);
//        }
//        exa.orderBy("rank").asc().orderBy("startTime").desc();


        PageHelper.startPage(query.getPage(), query.getLimit());
        List<Activity> activities = mapper.selectByQuery (query);
        return new PageInfo<Activity>(activities);

    }

    @Transactional(rollbackFor = Exception.class)
    public Boolean update(Activity activity) {
        try {
            activity.setUpdTime(System.currentTimeMillis());
            mapper.updateByPrimaryKeySelective(activity);
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return false;
        }

    }

    @Transactional(rollbackFor = Exception.class)
    public boolean add(Activity activity) {
        try {
            activity.setCrtTime(System.currentTimeMillis());
            activity.setIsDel(0);
            if (activity.getIsPublish() == null) {
                activity.setIsPublish(0);
            }
            mapper.insertSelective(activity);
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return false;
        }
    }

    @Override
    public void updateSelectiveById(Activity activity) {
        activity.setUpdTime(System.currentTimeMillis());
        mapper.updateByPrimaryKeySelective(activity);
    }


    public ObjectRestResponse checkQdlimits(Double latitude, Double longitude, Integer id){
        Map<String, Object> map= initParam(latitude,longitude,id);
        BigDecimal dinate=mapper.getdinate(map);
        int status=0;
        if (qdLimts.compareTo(dinate)>=0){
            status=1;
        }
        return  ObjectRestResponse.succ(status);
    }


    private Map<String, Object> initParam( Double latitude, Double longitude, Integer id) {
        Map<String,Object> params = new HashMap<String,Object>();
        params.put("latitude",latitude);
        params.put("longitude",longitude);
        params.put("id",id);
        return params;
    }
}
