package com.xxfc.platform.uccn.biz;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.xxfc.platform.uccn.dto.SeoDTO;
import com.xxfc.platform.uccn.entity.SEO;
import com.xxfc.platform.uccn.mapper.SEOMapper;
import com.xxfc.platform.uccn.vo.SEOQuery;
import com.xxfc.platform.uccn.vo.SEOVo;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import java.util.Date;
import java.util.List;

/**
 * @author Administrator
 */
@Service
public class SEOBackgroundBiz extends BaseBiz<SEOMapper, SEO> {
    public PageInfo<SeoDTO> getList(SEOQuery query) {
        PageHelper.startPage(query.getPage(),query.getLimit());
        List<SeoDTO> seodtoList = mapper.getSEODTOList();
        return PageInfo.of(seodtoList);
    }


    @Transactional(rollbackFor = Exception.class)
    public boolean update(SEOVo seoVo)  {

        try {
            if (seoVo==null) {

                return false;
            }
            SEO seo = new SEO();
            BeanUtilsBean.getInstance().copyProperties(seo,seoVo);
            if (seo.getId()==null) {
                seo.setCreTime(new Date());
                mapper.insertSelective(seo);
            }else {
                seo.setUpdTime(new Date());
                mapper.updateByPrimaryKeySelective(seo);
            }
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return false;
        }
    }
}
