package com.xxfc.platform.vehicle.biz;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.vehicle.constant.ResCode.ResCode;
import com.xxfc.platform.vehicle.entity.Vehicle;
import com.xxfc.platform.vehicle.entity.VehicleDepartureLog;
import com.xxfc.platform.vehicle.mapper.VehicleDepartureLogMapper;
import com.xxfc.platform.vehicle.mapper.VehicleMapper;
import com.xxfc.platform.vehicle.pojo.VehicleDepartureLogVo;
import com.xxfc.platform.vehicle.pojo.VehicleDepartureStatisticDataVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.weekend.WeekendSqls;

import java.util.Arrays;
import java.util.Date;
import java.util.List;

@Service
public class VehicleDepartureService extends BaseBiz<VehicleDepartureLogMapper, VehicleDepartureLog> {

    @Autowired
    VehicleDepartureLogMapper vehicleDepartureLogMapper;

    @Autowired
    VehicleMapper vehicleMapper;

    public PageInfo<VehicleDepartureLogVo> page(String numberPlate, Integer page, Integer limit) {
        PageHelper.startPage(page, limit);
        return new PageInfo<>(vehicleDepartureLogMapper.selectVoAll(numberPlate));
    }

    public PageInfo<VehicleDepartureLogVo> pageNotAllData(String numberPlate, Integer page, Integer limit, List<Integer> companyList) {
        PageHelper.startPage(page, limit);
        if (companyList == null || companyList.size() == 0) {
            companyList = Arrays.asList(-1);
        }
        return new PageInfo<>(vehicleDepartureLogMapper.selectVoAllNotAllData(numberPlate, companyList));
    }

    public PageInfo<VehicleDepartureLogVo> findByVehicle(String vehicleId, Integer page, Integer limit) {
        PageHelper.startPage(page, limit);
        return new PageInfo<>(vehicleDepartureLogMapper.selectByVehicleId(vehicleId));
    }

    public VehicleDepartureStatisticDataVo statistic(String numberPlate) {
        Vehicle vehicle = vehicleMapper.selectByNumberPlate(numberPlate);
        if (vehicle == null) {
            throw new BaseException(ResCode.VEHICLE_DEPARTURE_VEHICLE_UNEXIST.getDesc(),
                    ResCode.VEHICLE_DEPARTURE_VEHICLE_UNEXIST.getCode());
        }

        VehicleDepartureStatisticDataVo statisticData = new VehicleDepartureStatisticDataVo();
        // 出行次数
        VehicleDepartureLog departureLog = new VehicleDepartureLog();
        departureLog.setVehicleId(vehicle.getId());
        statisticData.setDepartureCount(vehicleDepartureLogMapper.selectCount(departureLog));
        // 出行天数
        statisticData.setDepartureDay(vehicleDepartureLogMapper.selectDayByVehicleId(vehicle.getId()));
        // 出行公里数
        statisticData.setDepartureMileage(vehicleDepartureLogMapper.selectMileageByVehicleId(vehicle.getId()));
        return statisticData;
    }


    @Transactional
    public ObjectRestResponse save(VehicleDepartureLog vehicleDepartureLog) {

        Integer id = vehicleDepartureLog.getId();
        if (id == null || id == 0) {
            vehicleDepartureLog.setCreateTime(new Date());
            vehicleDepartureLog.setState(0);
            insertSelective(vehicleDepartureLog);
        } else {
             vehicleDepartureLog.setUpdateTime(new Date());
            updateSelectiveById(vehicleDepartureLog);
        }

        return ObjectRestResponse.succ();
    }



    public ObjectRestResponse findOne(Integer vid) throws Exception {
        Example exm = Example.builder(VehicleDepartureLog.class)
                .where(WeekendSqls.<VehicleDepartureLog>custom()
                        .andEqualTo(VehicleDepartureLog::getVehicleId, vid)
                        .andEqualTo(VehicleDepartureLog::getState, 0))
                .orderByDesc("create_time")
                .build();

        List<VehicleDepartureLog> vehicleDepartureLogs = mapper.selectByExample(exm);
        if (vehicleDepartureLogs.size() == 1) {
            VehicleDepartureLog vehicleDepartureLog = vehicleDepartureLogs.get(1);
            if (vehicleDepartureLog!=null) {
                return ObjectRestResponse.succ(vehicleDepartureLog);
            }
        }
        return ObjectRestResponse.createDefaultFail();
    }

    @Transactional
    public ObjectRestResponse collect(VehicleDepartureLog vdl){
          vdl.setArrivalTime(new Date());
         vdl.setState(1);
         updateSelectiveById(vdl);
         return ObjectRestResponse.succ();
    }


}
