package com.xxfc.platform.order.rest;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.order.biz.OrderVehicalCrosstownBiz;
import com.xxfc.platform.order.entity.OrderVehicaleCrosstown;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping(value = "/orderVehicle")
@Api(value = "交还车记录", tags = {"交还车记录"})
@Slf4j
public class OrderVehicleCrosstownController {

    @Autowired
    OrderVehicalCrosstownBiz orderVehicalCrosstownBiz;

    @PostMapping(value = "/add")
    @ApiOperation(value = "添加交还车记录")
    public ObjectRestResponse<?> add(OrderVehicaleCrosstown orderVehicaleCrosstown) {
        log.info("添加的参数：orderVehicaleCrosstown = {}", orderVehicaleCrosstown);
        if (orderVehicaleCrosstown == null) {
            return ObjectRestResponse.createFailedResult(500, "参数为空！");
        }
        if (orderVehicaleCrosstown.getId() != null) {
            OrderVehicaleCrosstown oldValue = orderVehicalCrosstownBiz.get(orderVehicaleCrosstown.getId());
            if (oldValue != null) {
                BeanUtil.copyProperties(orderVehicaleCrosstown, oldValue, CopyOptions.create().setIgnoreNullValue(true).setIgnoreError(true));
                orderVehicalCrosstownBiz.updateSelectiveById(oldValue);
                return ObjectRestResponse.succ();
            }
            orderVehicalCrosstownBiz.insertSelective(orderVehicaleCrosstown);
            return ObjectRestResponse.succ();
        } else {
            orderVehicalCrosstownBiz.insertSelective(orderVehicaleCrosstown);
            return ObjectRestResponse.succ();
        }

    }

    @GetMapping(value = "/{id}")
    @ApiOperation(value = "查询记录信息")
    public ObjectRestResponse<OrderVehicaleCrosstown> get(@PathVariable Integer id) {
        return ObjectRestResponse.succ(orderVehicalCrosstownBiz.get(id));
    }

    @GetMapping(value = "/getByOrderId")
    @ApiOperation(value = "根据订单Id获取所有记录信息")
    public ObjectRestResponse<List<OrderVehicaleCrosstown>> getByOrderId(OrderVehicaleCrosstown orderVehicaleCrosstown) {
        if (orderVehicaleCrosstown == null) {
            return ObjectRestResponse.createFailedResult(500, "参数orderId为空");
        }
        return ObjectRestResponse.succ(orderVehicalCrosstownBiz.selectByOrderId(orderVehicaleCrosstown));
    }

}
