package com.xxfc.platform.order.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-19 17:00:35
 */
@Data
@Table(name = "order_member_detail")
public class OrderMemberDetail implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  主键
   */
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键")
    private Integer id;
	
	    /**
     *  基础订单id
     */
    @Column(name = "order_id")
	@ApiModelProperty(value = "基础订单id")
    private Integer orderId;
	
	    /**
     *  名称
     */
    @Column(name = "name")
	@ApiModelProperty(value = "名称")
    private String name;
	
	    /**
     *  创建时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;
	
	    /**
     *  更新时间
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;
	
	    /**
     *  出租免费天数
     */
    @Column(name = "rent_free_num")
	@ApiModelProperty(value = "出租免费天数")
    private Integer rentFreeNum;
	
	    /**
     *  折扣比例 80即 八折
     */
    @Column(name = "rebate")
	@ApiModelProperty(value = "折扣比例 80即 八折")
    private Integer rebate;

	/**
	 *  会员等级
	 */
	@Column(name = "member_level")
	@ApiModelProperty(value = "会员等级")
	private Integer memberLevel;
}
