package com.xxfc.platform.campsite.rest.admin;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.campsite.biz.CampsiteShopBiz;
import com.xxfc.platform.campsite.dto.CampsiteShopAdminDTO;
import com.xxfc.platform.campsite.dto.CampsiteShopAdminFindDTO;
import com.xxfc.platform.campsite.entity.CampsiteShop;
import com.xxfc.platform.campsite.vo.CampsiteShopAdminPageVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

/**
 * @author libin
 * @version 1.0
 * @description 营地店铺
 * @data 2019/6/17 13:37
 */
@RestController
@RequestMapping("/admin/campsiteShop")
@Api(value = "营地店铺",tags = "后台营地店铺")
public class CampsiteShopAdminController extends BaseController<CampsiteShopBiz,CampsiteShop> {

    /**
     * 按条件分页查询 营地列表
     * @param campsiteShopAdminFindDTO
     * @return
     */
    @ApiOperation(value = "营地列表")
    @GetMapping("/pages")
    public ObjectRestResponse<PageDataVO<CampsiteShopAdminPageVo>> findCampsiteShopPage(CampsiteShopAdminFindDTO campsiteShopAdminFindDTO){
        PageDataVO<CampsiteShopAdminPageVo> pageVoPageDataVO = getBaseBiz().findCampsiteShopPage(campsiteShopAdminFindDTO);
        return ObjectRestResponse.succ(pageVoPageDataVO);
    }

    /**
     * 营地保存
     * @param campsiteShopAdminDTO
     * @return
     */
    @PostMapping("/save")
    public ObjectRestResponse<Void> saveCampistieShop(@RequestBody CampsiteShopAdminDTO campsiteShopAdminDTO){
        int effectRows = getBaseBiz().saveCampsiteShop(campsiteShopAdminDTO);
        if (effectRows>0){
         return ObjectRestResponse.succ();
        }
        return ObjectRestResponse.createDefaultFail();
    }

}