package com.xxfc.platform.campsite.mapper;

import com.xxfc.platform.campsite.dto.CampsiteShopAdminFindDTO;
import com.xxfc.platform.campsite.dto.CampsiteShopAdminPageDTO;
import com.xxfc.platform.campsite.dto.CampsiteShopDetailDTO;
import com.xxfc.platform.campsite.dto.CampsiteShopPageDTO;
import com.xxfc.platform.campsite.entity.CampsiteShop;
import org.apache.ibatis.annotations.Param;
import tk.mybatis.mapper.common.Mapper;

import java.util.List;

/**
 * 营地店铺表
 * 
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-06-17 10:28:48
 */
public interface CampsiteShopMapper extends Mapper<CampsiteShop> {


    /**
     * 根据店铺类型查找店铺列表
     * @param typeId
     */
    List<CampsiteShopPageDTO> findCampsiteShopsByType(@Param("typeId") Integer typeId);

    /**
     * 根据店铺id查询
     * @param id
     * @return
     */
    CampsiteShopDetailDTO findCampsiteShopDetailById(Integer id);

    /**
     * 根据条件查询
     * @param campsiteShopAdminFindDTO
     * @return
     */
    List<CampsiteShopAdminPageDTO> findCampsiteShops(CampsiteShopAdminFindDTO campsiteShopAdminFindDTO);
}
