package com.xxfc.platform.campsite.biz;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.xxfc.platform.campsite.dto.CampsiteTagListDTO;
import com.xxfc.platform.campsite.vo.CampsiteTagListVo;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import com.xxfc.platform.campsite.entity.CampsiteTag;
import com.xxfc.platform.campsite.mapper.CampsiteTagMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;

import java.util.List;

/**
 * 店铺类型表
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-06-17 10:28:48
 */
@Service
public class CampsiteTagBiz extends BaseBiz<CampsiteTagMapper,CampsiteTag> {

    /**
     * 查询营地列表
     * @return
     */
    public List<CampsiteTagListVo> findCampsiteTags() {
        List<CampsiteTagListDTO> campsiteTagListDTOS = mapper.findCampsiteTags();
        if (CollectionUtils.isEmpty(campsiteTagListDTOS)){
            return  null;
        }
        List<CampsiteTagListVo> campsiteTagListVos = JSONObject.parseObject(JSONObject.toJSONString(campsiteTagListDTOS),new TypeReference<List<CampsiteTagListVo>>(){});
        return campsiteTagListVos;
    }

    /**
     * 更新营地类型状态
     * @param tagId
     * @return
     */
    public int updateCampsiteTagStatus(Integer tagId) {
       return mapper.updateCampsiteTagStatus(tagId,1);
    }
}