package com.xxfc.platform.campsite.biz;

import com.alibaba.fastjson.JSONObject;
import com.xxfc.platform.campsite.dto.CampsiteShopCarouselDetailDTO;
import com.xxfc.platform.campsite.dto.CampsiteShopTagDTO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import com.xxfc.platform.campsite.entity.CampsiteShopTag;
import com.xxfc.platform.campsite.mapper.CampsiteShopTagMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 店铺类型表
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-06-17 10:28:48
 */
@Service
@Slf4j
public class CampsiteShopTagBiz extends BaseBiz<CampsiteShopTagMapper,CampsiteShopTag> {
    /**
     * 根据店铺id查询
     * @param id
     * @return
     */
    public List<String> findByCampsiteShopId(Integer id) {
        return mapper.findByCampsiteShopId(id);
    }

    /**
     * 根据店铺ids查询
     * @param campsiteShopIds
     * @return
     */
    public Map<Integer, List<String>> findByCampsiteShopIds(List<Integer> campsiteShopIds) {
         List<CampsiteShopTagDTO> campsiteShopTagDTOS = mapper.findByCampsiteShopIds(campsiteShopIds);
         if (CollectionUtils.isEmpty(campsiteShopTagDTOS)){
             return null;
         }
        Map<Integer, List<String>> shopOfTagsMap = campsiteShopTagDTOS.stream()
                .collect(Collectors.groupingBy(CampsiteShopTagDTO::getShopId,Collectors.mapping(CampsiteShopTagDTO::getTagName,Collectors.toList())));
         return shopOfTagsMap;
    }

    /**
     * 批量保存
     * @param campsiteTagIds
     * @return
     */
    @Transactional(rollbackFor = Exception.class,propagation = Propagation.REQUIRED)
    public int saveBatch(List<Integer> campsiteTagIds,Integer shopId) {
       int effectRows =  mapper.deleteByShopId(shopId);
        if (CollectionUtils.isNotEmpty(campsiteTagIds)){
              List<CampsiteShopTagDTO> campsiteShopTagDTOS = campsiteTagIds.stream().map(id -> {
                  CampsiteShopTagDTO campsiteShopTagDTO = new CampsiteShopTagDTO();
                  campsiteShopTagDTO.setTagId(id);
                  campsiteShopTagDTO.setShopId(shopId);
                  campsiteShopTagDTO.setCrtTime(Instant.now().toEpochMilli());
                  return campsiteShopTagDTO;
              }).collect(Collectors.toList());
              if (log.isDebugEnabled()){
                  log.debug("保存的营地与标签的信息：【{}】",campsiteShopTagDTOS);
              }
              mapper.saveBatch(campsiteShopTagDTOS);
          }
     return effectRows;
    }
}