package com.xxfc.platform.campsite.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;


/**
 * 营地店铺表
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-06-17 10:28:48
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(value = "营地店铺*后台dto")
public class CampsiteShopAdminPageDTO implements Serializable {
    private static final long serialVersionUID = 1L;


    @ApiModelProperty("主键id")
    private Integer id;

    /**
     * 店铺名称
     */
    @ApiModelProperty(value = "店铺名称")
    private String name;

    /**
     * 店铺类型名称
     */
    @ApiModelProperty(value = "店铺类型名称")
    private List<String> storeTypeName;
    /**
     * 热度值
     */
    @ApiModelProperty(value = "热度值")
    private Integer hot;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间", hidden = true)
    private Long crtTime;

    /**
     * 上下架状态 0-创建状态  1-上架 2-下架
     */
    @ApiModelProperty(value = "上下架状态 0-创建状态  1-上架 2-下架")
    private Integer saleState;
}
