package com.xxfc.platform.vehicle.pojo.dto;


import com.github.wxiaoqi.security.common.constant.CommonConstants;
import com.github.wxiaoqi.security.common.vo.DataInter;
import com.github.wxiaoqi.security.common.vo.PageParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.List;

import static com.github.wxiaoqi.security.common.constant.CommonConstants.YMR_SLASH_FORMATTER;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/8/23 16:27
 */
@Data
public class VehicleFindDTO extends PageParam implements DataInter {

    public static final DateTimeFormatter DEFAULT_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");


    @ApiModelProperty("商品Id")
    private String vehicleId;


    @ApiModelProperty("商品名称")
    private String  name;


    @ApiModelProperty("商品类型 1--房车；2--机车；3--游艇")
    private Integer  goodsType;

    @ApiModelProperty("状态：1-上架；2-下架")
    private Integer  state;

    @ApiModelProperty("品牌id")
    private Integer  brandId;


    @ApiModelProperty("型号id")
    private Integer  categoryId;


    @ApiModelProperty("店铺id")
    private Integer  branchId;

    @ApiModelProperty("是否全网最低价")
    private Integer  isMinPrice;


    List<Integer> dataCorporationIds;

    List<Integer> dataCompanyIds;

    Integer bizType;

    @ApiModelProperty("店铺类型：1-店铺资产；2-店铺经营；3-店铺停靠")
    private Integer  type;


    @ApiModelProperty("店铺状态：1-上架中；2-下架中；3-已调出")
    private Integer  goodStatus;

    private List<String> vehicleIdList;


    /**
     * 预定目标日期(开始)
     */
    @ApiModelProperty("目标日期(开始)")
    private String bookStartDate;

    /**
     * 预定目标日期(结束)
     */
    @ApiModelProperty("目标日期(结束)")
    private String  bookEndDate;

    /**
     * 预定目标日期(开始)
     */
    @ApiModelProperty("目标时间(开始)")
    private String  bookStartDateTime;

    /**
     * 预定目标日期(结束)
     */
    @ApiModelProperty("目标时间(结束)")
    private String  bookEndDateTime;


    @ApiModelProperty("开始时间戳")
    Long startDateTamp;
    @ApiModelProperty("结束时间戳")
    Long endDateTamp;





    public void setStartDateTamp(Long startDateTamp) {
        this.startDateTamp = startDateTamp;
        this.bookStartDate = DEFAULT_DATE_TIME_FORMATTER.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(startDateTamp), ZoneOffset.ofHours(8)));
        this.bookStartDateTime = CommonConstants.DATE_TIME_LINE_FORMATTER.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(startDateTamp), ZoneOffset.ofHours(8)));
    }

    public void setEndDateTamp(Long endDateTamp) {
        this.endDateTamp = endDateTamp;
        this.bookEndDate = DEFAULT_DATE_TIME_FORMATTER.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(endDateTamp), ZoneOffset.ofHours(8)));
        this.bookEndDateTime = CommonConstants.DATE_TIME_LINE_FORMATTER.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(endDateTamp), ZoneOffset.ofHours(8)));
    }
}
