package com.xxfc.platform.universal.entity;


import io.swagger.annotations.ApiModel;
import lombok.Data;

import javax.persistence.*;
import java.math.BigDecimal;
import java.util.Date;

@Data
@Table(name = "invoice")
@ApiModel
public class Invoice {
  @Id
  @GeneratedValue(strategy = GenerationType.IDENTITY)
  private Integer id;
  /**
   * 用户id
   */
  private Integer userId;
  /**
   * 订单id :多个以逗号隔开
   */
  private String orderId;

  /**
   * 发票订单表id
   */
  private Integer orderInvoiceId;



  /**
   * 发票订单号
   */
  private String orderNo;


  /**
   * 公司代码
   */
  private String companyCode;


  /**
   * 机构代码
   */
  private String orgCode;


  /**
   * 发票代码
   */
  private String invoiceCode;

  /**
   * 发票号码
   */
  private String invoiceNo;

  /**
   * 开票日期
   */
  private Date invoiceDate;

  /**
   * 发票分类：01 专票,02 货物运输业增值税专用发票,03 机动车销售统一发票，
   * 04 增值税普通发票，10 增值税普通发票（电子），11 增值税普通发票（卷票），14 增值税普通发票（卷票）
   */
  private Integer invoiceCategory;

  /**
   * 合计金额
   */
  private BigDecimal invoiceAmount;

  /**
   * 合计税额
   */
  private BigDecimal taxAmount;

  /**
   * 价税合计总额
   */
  private BigDecimal invoiceSummaryAmount;

  /**
   * 价税合计总额大写
   */
  private String invoiceSummaryAmountText;
  /**
   * 备注
   */
  private String remark;
  /**
   * 验证码
   */
  private String verifyCode;
  /**
   * 机器编号
   */
  private String machineNo;
  /**
   * 密码区
   */
  private String invoicePassword;
  /**
   * 地区
   */
  private String areaCode;
  /**
   * 地区名称
   */
  private String areaName;
  /**
   * 销售方名称
   */
  private String salerName;
  /**
   * 销售方纳税人识别号
   */
  private String salerTaxCode;
  /**
   * 销售方地址
   */
  private String salerAddress;

  /**
   * 销售方电话
   */
  private String salerPhone;

  /**
   * 销售方银行及账户
   */
  private String salerAccountBank;
  /**
   * 购买方名称
   */
  private String purchaserName;
  /**
   * 购买方纳税人识别号
   */
  private String purchaserTaxCode;
  /**
   * 购方手机
   */
  private String purchaserPhone;
  /**
   * 购方邮箱
   */
  private String purchaserEmail;
  /**
   * 购买方地址电话
   */
  private String purchaserAddressPhone;
  /**
   * 购买方银行账号
   */
  private String purchaserAccountBank;
  /**
   * 收款人
   */
  private String payee;
  /**
   * 复核人
   */
  private String reviewer;
  /**
   * 开票人
   */
  private String issuer;
//  /**
//   * 发票状态
//   */
//  private Integer invoiceStatus;
  /**
   * 附件
   */
  private String attachment;
  /**
   * 原票代码
   */
  private String originalCode;
  /**
   * 原票号
   */
  private String originalNo;
  /**
   * 查验状态
   */
  private Integer recognizeFlag;
  /**
   * 查验
   */
  private Integer validState;
  /**
   *  开票状态 0:未开票;1:开票中;2:为开票成功;3:开票失败;
   */
  private Integer status;
  /**
   * 发票图片链接
   */
  private String pictureUrl;
  /**
   * 开票类型:1-正票;2-红票
   */
  private Integer invoiceType=1;
  /**
   * 开票内容
   */
  private String content;
  /**
   * 推送方式:-1,不推送;0,邮箱;1,手机（默认）;2,邮箱、手机
   */
  private Integer pushMode=2;
  /**
   * 开票代码
   */
  private String invoiceSerialNum;
  private String createBy;
  private String updateBy;
  private Date createTime;
  private Date updateTime;

}
