package com.xxfc.platform.uccn.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;


/**
 * 轮播图
 * 
 * @author libin
 * @email 18178966185@163.com
 * @date 2020-11-23 13:52:29
 */
@Data
@Table(name = "banner")
public class Banner implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  首页banner图主键
   */
    @Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@ApiModelProperty("首页banner图主键")
    private Integer id;
	
	    /**
     *  标题
     */
    @Column(name = "title")
	@ApiModelProperty(value = "标题")
    private String title;
	
	    /**
     *  封面
     */
    @Column(name = "cover")
	@ApiModelProperty(value = "封面")
    private String cover;
	
	    /**
     *  排序
     */
    @Column(name = "rank")
	@ApiModelProperty(value = "排序")
    private Integer rank;
	
	    /**
     *  创建时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Date crtTime;
	
	    /**
     *  修改时间
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "修改时间", hidden = true )
    private Date updTime;
	
	    /**
     *  跳转链接
     */
    @Column(name = "url")
	@ApiModelProperty(value = "跳转链接")
    private String url;
	
	    /**
     *  是否删除，0否，1是
     */
    @Column(name = "is_del")
	@ApiModelProperty(value = "是否删除，0否，1是")
    private Integer isDel;
	
	    /**
     *  状态1--上架；2--下架
     */
    @Column(name = "status")
	@ApiModelProperty(value = "状态1--上架；2--下架")
    private Integer status;
	
	    /**
     *  是否首页展示：1、展示，2、不展示
     */
    @Column(name = "index_show")
	@ApiModelProperty(value = "是否首页展示：1、展示，2、不展示")
    private Integer indexShow;

    //banner位置 0：所有 1：首页
    private Integer location;

    //跳转类型 0--不跳转；1--商品详情页；2--店铺主页；
    private Integer jumpType;

    private String jumpId;

}
