package com.xxfc.platform.order.rest.background;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.github.wxiaoqi.security.admin.feign.rest.UserRestInterface;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.msg.TableResultResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.order.biz.BaseOrderBiz;
import com.xxfc.platform.order.biz.OrderPersonInsuranceBiz;
import com.xxfc.platform.order.entity.BaseOrder;
import com.xxfc.platform.order.entity.OrderPersonInsurance;
import com.xxfc.platform.order.pojo.personinsurance.BgPageDTO;
import com.xxfc.platform.order.pojo.personinsurance.BgPageVO;
import io.swagger.annotations.ApiOperation;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import zipkin2.Call;

import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/background/orderPersonInsurance")
@Slf4j
public class BgOrderPersonInsuranceController extends BaseController<OrderPersonInsuranceBiz, OrderPersonInsurance> {
    @Autowired
    BaseOrderBiz baseOrderBiz;

    @ApiOperation("查询分页")
    @RequestMapping(value = "/pageList",method = RequestMethod.GET)
    @ResponseBody
    public ObjectRestResponse<PageDataVO<BgPageVO>> pageList(BgPageDTO dto){
        return ObjectRestResponse.succ(baseBiz.selectOrderInfo(dto));
    }

    @ApiOperation("修改图片")
    @RequestMapping(value = "/editPic",method = RequestMethod.POST)
    @ResponseBody
    public ObjectRestResponse editPic(@RequestBody BgPageDTO dto){
        baseOrderBiz.updateByWeekendSelective(new BaseOrder(){{
            setInsurePic(dto.getInsurePic());
        }}, w -> {
            w.andEqualTo(BaseOrder::getNo, dto.getNo());
            return w;
        });
        return ObjectRestResponse.succ();
    }

    @RequestMapping(value="/pageExport", method = RequestMethod.GET)
    public void bgPageExport(BgPageDTO dto) throws Exception{
        PageExportDTO head = new PageExportDTO(){{
            setOrderNo("订单编号");
            setName("姓名");
            setIdCard("身份证号");
            setRentDateStr("租期");
            setAmountStr("保险档次");
            setPayTimeStr("下单时间");
            setRefundTimeStr("退保时间");
            setStatusStr("状态");
            setBuyInsureIdCard("投保人身份证");
            setBuyInsurePhone("投保人手机号");
            setBuyInsureName("投保人名称");
        }};
        exportBean(log, head, () -> {
            List<OrderPersonInsurance> bgList = baseBiz.selectInsuranceInfo(dto);
            List<Map> list = CollUtil.newArrayList();
            bgList.forEach(vo -> {
                //OrderNo Name IdCard
                PageExportDTO ped = BeanUtil.toBean(vo, PageExportDTO.class);
                if(StrUtil.isBlank(vo.getBuyInsureIdCard())) {
                    ped.setBuyInsureIdCard("");
                }
                if(StrUtil.isBlank(vo.getBuyInsureName())) {
                    ped.setBuyInsureName("");
                }
                if(StrUtil.isBlank(vo.getBuyInsurePhone())) {
                    ped.setBuyInsurePhone("");
                }
                switch (vo.getStatus()) {
                    case OrderPersonInsurance.STATUS_PAY:
                        ped.setStatusStr("已购买");
                        ped.setRefundTimeStr("");
                        break;
                    case OrderPersonInsurance.STATUS_CNL:
                        ped.setStatusStr("已退保");
                        ped.setRefundTimeStr(DateUtil.date(vo.getRefundTime()).toString());
                        break;
                    default:
                        ped.setStatusStr("");
                        ped.setRefundTimeStr("");
                        break;
                }

                ped.setAmountStr(vo.getAmount()+ "元");
                String startStr = DateUtil.date(vo.getStartTime()).toDateStr();
                String endStr = DateUtil.date(vo.getEndTime()).toDateStr();
                ped.setRentDateStr(startStr+ "-"+ endStr);
                ped.setPayTimeStr(DateUtil.date(vo.getPayTime()).toString());
                list.add(BeanUtil.beanToMap(ped,false, true));
            });
            return list;
        },"保险导出");
    }

    @Data
    static class PageExportDTO {
        private String orderNo;
        private String name;
        private String idCard;
        private String rentDateStr;
        private String amountStr;
        private String payTimeStr;
        private String refundTimeStr;
        private String statusStr;
        private String buyInsureName;
        private String buyInsureIdCard;
        private String buyInsurePhone;
    }

}