package com.github.wxiaoqi.security.admin.rest.admin;

import com.github.wxiaoqi.security.admin.biz.AppUserRelationBiz;
import com.github.wxiaoqi.security.admin.dto.AppUserRelationDTO;
import com.github.wxiaoqi.security.admin.dto.UserRelationDTO;
import com.github.wxiaoqi.security.admin.entity.AppUserRelation;
import com.github.wxiaoqi.security.admin.vo.InviteMemberVo;
import com.github.wxiaoqi.security.auth.common.util.jwt.IJWTInfo;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

@RestController
@RequestMapping("relation/admin")
public class
AdminUserRelationController extends BaseController<AppUserRelationBiz,AppUserRelation> {


    @RequestMapping(value = "/bind",method = RequestMethod.POST)
    @ApiModelProperty("后台绑定")
    public ObjectRestResponse bind(@RequestBody UserRelationDTO relationDTO){
        try {
        return baseBiz.adminBindRelation(relationDTO);
        } catch (Exception e) {
            e.printStackTrace();
            throw new BaseException(e);
        }
    }



    @ApiOperation("用户下线")
    @GetMapping("/pages")
    public ObjectRestResponse<InviteMemberVo> findInviteMemberByActivitState(AppUserRelationDTO userRelationDTO) {
        return ObjectRestResponse.succ(baseBiz.selectList(userRelationDTO));
    }


    @RequestMapping(value = "unBind",method = RequestMethod.POST)
    @ApiModelProperty("后台解绑")
    public ObjectRestResponse unBind(@RequestBody AppUserRelation appUserRelation){


        AppUserRelation appUserRelation1 = baseBiz.selectById(appUserRelation.getId());
        if (appUserRelation1 != null)
            appUserRelation.setUserId(appUserRelation1.getUserId());
        appUserRelation.setParentId(0);
        appUserRelation.setBindTime(0L);
        appUserRelation.setIsForever(0);
        baseBiz.updRelation(appUserRelation);
        return ObjectRestResponse.succ();
    }
}