package com.github.wxiaoqi.security.admin.rest.admin;

import com.github.wxiaoqi.security.admin.biz.AppUserJobLevelBiz;
import com.github.wxiaoqi.security.admin.biz.AppUserPositionBiz;
import com.github.wxiaoqi.security.admin.biz.AppUserPositionTempBiz;
import com.github.wxiaoqi.security.admin.dto.AppUserPositionTempDTO;
import com.github.wxiaoqi.security.admin.dto.AppUserPositionTempFindDTO;
import com.github.wxiaoqi.security.admin.dto.UserPostionDTO;
import com.github.wxiaoqi.security.admin.entity.AppUserPositionTemp;
import com.github.wxiaoqi.security.admin.vo.AppUserPositionTempVo;
import com.github.wxiaoqi.security.admin.vo.WalletPostionVo;
import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.github.wxiaoqi.security.auth.client.jwt.UserAuthUtil;
import com.github.wxiaoqi.security.auth.common.util.jwt.IJWTInfo;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.excel.ExcelImport;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/17 16:13
 */
@Slf4j
@RestController
@RequestMapping("/postion/admin")
public class AppUserPositionController {

    @Autowired
    private AppUserPositionBiz appUserPositionBiz;

    @Autowired
    private AppUserJobLevelBiz jobLevelBiz;

    @Autowired
    private AppUserPositionTempBiz appUserPositionTempBiz;

    @Autowired
    private UserAuthUtil userAuthUtil;

    @Autowired
    private UserAuthConfig userAuthConfig;


    @GetMapping("/jobs")
    public ObjectRestResponse findAllJobs() {
        return ObjectRestResponse.succ(jobLevelBiz.selectListAll());
    }

    @GetMapping("/postions")
    public ObjectRestResponse<List<WalletPostionVo>> findAllPostions() {
        List<WalletPostionVo> walletPostionVos = appUserPositionBiz.findAllPostions();
        return ObjectRestResponse.succ(walletPostionVos);
    }

    @PutMapping
    public ObjectRestResponse updateUserPostionPercentage(@RequestBody List<UserPostionDTO> userPostionDTOS) {
        appUserPositionBiz.updateUserPostionPercentage(userPostionDTOS);
        return ObjectRestResponse.succ();
    }


    /**
     * 新增或编辑身份信息
     *
     * @return
     */
    @PostMapping("/addUserPostion")
    public ObjectRestResponse<Void> addUserPostion(@RequestBody AppUserPositionTempDTO appUserPositionTempDTO, HttpServletRequest request) {
        try {
            IJWTInfo infoFromToken = userAuthUtil.getInfoFromToken(userAuthConfig.getToken(request));
            Integer s = Integer.valueOf(infoFromToken.getId());
            return appUserPositionTempBiz.add(appUserPositionTempDTO, Integer.valueOf(infoFromToken.getId()));
        } catch (Exception e) {
            log.error("新增失败【{}】", e);
            throw new BaseException("新增失败");
        }
    }

    /**
     * 新增或编辑身份信息
     *
     * @return
     */
    @PostMapping("/updUserPostion")
    public ObjectRestResponse<Void> updUserPostion(@RequestBody AppUserPositionTempDTO appUserPositionTempDTO, HttpServletRequest request) {
        try {
            IJWTInfo infoFromToken = userAuthUtil.getInfoFromToken(userAuthConfig.getToken(request));
            return appUserPositionTempBiz.add(appUserPositionTempDTO, Integer.valueOf(infoFromToken.getId()));
        } catch (Exception e) {
            log.error("修改失败【{}】", e);
            throw new BaseException("修改失败");
        }
    }

    /**
     * 员工信息更改,并插入变更记录表
     * zuoyh
     *
     * @return
     */
    @PostMapping("/updUserChange")
    public ObjectRestResponse<Void> updUserChange(@RequestBody AppUserPositionTempDTO appUserPositionTempDTO, HttpServletRequest request) {
        try {
            IJWTInfo infoFromToken = userAuthUtil.getInfoFromToken(userAuthConfig.getToken(request));
            Integer operatorId = Integer.valueOf(infoFromToken.getId());
            return ObjectRestResponse.succ(appUserPositionTempBiz.addUserPositionChangeRecord(appUserPositionTempDTO.getChangeStatus(), appUserPositionTempDTO, operatorId));
        } catch (Exception e) {
            log.error("修改失败【{}】", e);
            throw new BaseException("修改失败");
        }

    }

    /**
     * 查询员工信息变更记录表
     */
    @GetMapping("/findPositionChangeRecord")
    public ObjectRestResponse findPositionChangeRecord(AppUserPositionTemp appUserPositionTemp) {
        return ObjectRestResponse.succ(appUserPositionTempBiz.findPositionChangeRecord(appUserPositionTemp));
    }

    /**
     * 员工复职位
     */
    @PostMapping("/updAddPositionChangeRecord")
    public ObjectRestResponse updAddPositionChangeRecord(@RequestBody AppUserPositionTempDTO appUserPositionTempDTO, HttpServletRequest request) {
        try {
            IJWTInfo infoFromToken = userAuthUtil.getInfoFromToken(userAuthConfig.getToken(request));
            Integer operatorId = Integer.valueOf(infoFromToken.getId());
            return ObjectRestResponse.succ(appUserPositionTempBiz.andAddUserPositionChangeRecord(appUserPositionTempDTO, operatorId));
        } catch (Exception e) {
            log.error("修改失败【{}】", e);
            throw new BaseException("修改失败");
        }
    }

    /**
     * 批量导入
     *
     * @param userPostionExcel
     * @return
     */
    @PostMapping("/excel/import")
    public ObjectRestResponse<Map<String, Object>> importUserPostion(@RequestPart("file") MultipartFile userPostionExcel) {
        List<String[]> userPostionData = ExcelImport.getExcelData(userPostionExcel);
        if (userPostionData.size() < 2) {
            return ObjectRestResponse.createFailedResult(1001, "导入不能没数据！！！");
        }
        userPostionData.remove(0);
        Map<String, Object> result = appUserPositionTempBiz.importUserPostion(userPostionData);
        return ObjectRestResponse.succ(result);
    }

    /**
     * 删除
     *
     * @param id
     * @return
     */
    @DeleteMapping("/{id}")
    public ObjectRestResponse<Void> deleteUserPostion(@PathVariable(value = "id") Integer id) {
        appUserPositionTempBiz.updateAppuserPostionStatusById(id, 1);
        return ObjectRestResponse.succ();
    }

    @PostMapping("/page")
    public ObjectRestResponse<PageDataVO<AppUserPositionTempVo>> findWithPage(@RequestBody AppUserPositionTempFindDTO appUserPositionTempFindDTO) {
        PageDataVO<AppUserPositionTempVo> dataVO = appUserPositionTempBiz.findWithPage(appUserPositionTempFindDTO);
        return ObjectRestResponse.succ(dataVO);
    }


    @GetMapping("/userid")
    public List<Integer> getUserIdByParentCompany(@RequestParam("parentCompanyId") List<Integer> parentCompanyId) {
        return appUserPositionTempBiz.getUserIdByParentCompany(parentCompanyId);
    }

}
