package com.xxfc.platform.summit.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import javax.persistence.*;
import java.math.BigDecimal;

/**
 * 文章实体
 *
 * @author Administrator
 */
@Data
@Table(name = "fc_activity")
@Entity
@ApiModel(value = "峰会活动表")
public class Activity {

    @Id
    @GeneratedValue(generator="JDBC")
    private Integer id;

    @Column(name = "rid")
    @ApiModelProperty("抽奖活动id")
    private Integer rId;


    @Column(name = "title")
    @ApiModelProperty("活动主标题")
    private String title;


    @Column(name = "subtitle")
    @ApiModelProperty("副标题（不展示）")
    private String subtitle;


    @Column(name = "banner")
    @ApiModelProperty("活动主图")
    private String banner;

    @Column(name = "start_time")
    @ApiModelProperty("开始时间")
    private Long startTime;

    @Column(name = "end_time")
    @ApiModelProperty("结束时间")
    private Long endTime;

    @Column(name = "bm_close_time")
    @ApiModelProperty("报名截止时间（不展示）")
    private String bmCloseTime;

    @Column(name = "province_code")
    @ApiModelProperty("省编码")
    private Integer provinceCode;

    @Column(name = "province")
    @ApiModelProperty("省")
    private String province;

    @Column(name = "city_code")
    @ApiModelProperty("市编码")
    private Integer cityCode;

    @Column(name = "city")
    @ApiModelProperty("市")
    private String city;

    @Column(name = "town_code")
    @ApiModelProperty("县/镇 编码")
    private Integer townCode;

    @Column(name = "town")
    @ApiModelProperty("县/镇")
    private String town;

    @Column(name = "address")
    @ApiModelProperty("活动场地（地址格式）")
    private String address;

    @Column(name = "address_img")
    @ApiModelProperty("地址图片")
    private String addressImg;


    @Column(name = "latitude")
    @ApiModelProperty("纬度（不展示")
    private BigDecimal latitude;

    @Column(name = "longitude")
    @ApiModelProperty("经度 （不展示）")
    private BigDecimal longitude;


    @Column(name = "is_show")
    @ApiModelProperty("活动开关（1开，0关）")
    private Integer isShow;

    @Column(name = "is_open_bm")
    @ApiModelProperty("报名开关（1开，0关）")
    private Integer isOpenBm;

    @Column(name = "is_publish")
    @ApiModelProperty("0是未发布，1是已发布")
    private Integer isPublish;

    @Column(name = "status")
    @ApiModelProperty("0-默认；1-报名中，2-进行中；3-已结束")
    private Integer status;

    @Column(name = "content")
    @ApiModelProperty("活动图文内容（峰会主题）")
    private String content;

    @Column(name = "act_desc")
    @ApiModelProperty("活动对象说明（诚邀莅临）")
    private String actDesc;

    @Column(name = "company_desc")
    @ApiModelProperty("公司简章")
    private String companyDesc;

    @Column(name = "vehicle_imgs")
    @ApiModelProperty("房车介绍")
    private String vehicleImgs;

    @Column(name = "process_json")
    @ApiModelProperty("活动流程")
    private String processJson;

    @Column(name = "type")
    @ApiModelProperty("活动类型(保留，不展示)")
    private Integer type;

    @Column(name = "limit_num")
    @ApiModelProperty("总人数限制")
    private Integer limitNum;

    @Column(name = "bm_num")
    @ApiModelProperty("已报名人数")
    private Integer bmNum;

    @Column(name = "qd_num")
    @ApiModelProperty("已签到人数")
    private Integer qdNum;

    @Column(name = "rank")
    @ApiModelProperty("排序")
    private Integer rank;

    @Column(name = "crt_time")
    @ApiModelProperty("创建时间")
    private Long crtTime;

    @Column(name = "upd_time")
    @ApiModelProperty("修改时间")
    private Long updTime;

    @Column(name = "is_del")
    @ApiModelProperty("删除（0正常，1删除）")
    private Integer isDel;


}
