package com.xxfc.platform.order.biz;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import com.xxfc.platform.order.contant.enumerate.ItemTypeEnum;
import com.xxfc.platform.vehicle.feign.VehicleFeign;
import com.xxfc.platform.vehicle.pojo.dto.VehicleModelCalendarPriceDTO;
import com.xxfc.platform.vehicle.pojo.dto.order.VMCalendarPriceCostDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.xxfc.platform.order.entity.OrderItem;
import com.xxfc.platform.order.mapper.OrderItemMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 购房车提交表单
 *
 * @author zjw
 * @email 18178966185@163.com
 * @date 2019-07-23 17:33:06
 */
@Service
public class OrderItemBiz extends BaseBiz<OrderItemMapper,OrderItem> {

    @Autowired
    VehicleFeign vehicleFeign;

    public OrderItem initOrderItem(BigDecimal price, Integer num, String name, Integer goodId, ItemTypeEnum itemTypeEnum, String detail){
        return new OrderItem(){{
            setMetaUnitPrice(price);
            setUnitPrice(price);
            setBuyNum(num);
            setTotalNum(num);
            setAwardNum(0);
            setCutNum(0);
            setCouponAmount(BigDecimal.ZERO);
            setName(name);
            setGoodId(goodId);
            setType(itemTypeEnum.getCode());
            setDetail(detail);
        }};
    }

    public OrderItem initOrderItem(BigDecimal price, Integer num, String name, Integer goodId, ItemTypeEnum itemTypeEnum){
        return initOrderItem(price, num, name, goodId, itemTypeEnum, null);
    }

    public List<VMCalendarPriceCostDTO> getOverAmountList(Date endDate, Integer overDays, Integer modelId, Integer userId) {
        List<VMCalendarPriceCostDTO> overAmountList = CollUtil.newArrayList();
        //根据延期的天数算出 对应的日期价格
        Date overStart = DateUtil.offsetDay(endDate, 1);
        Date overEnd = DateUtil.offsetDay(endDate, overDays);
        List<VehicleModelCalendarPriceDTO> overlist = vehicleFeign.findVehicleModelCalendarPriceByDate(overStart, overEnd, modelId, userId);

        for(VehicleModelCalendarPriceDTO vmcpd : overlist) {
            overAmountList.add((VMCalendarPriceCostDTO) vmcpd);
        }
        return overAmountList;
    }
}