package com.xxfc.platform.order.pojo.price;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@Data
public class TourPriceVO extends OrderPriceVO{
    @ApiModelProperty(value = "费用详情")
    private String costDetail = "";
    @ApiModelProperty(value = "成人人数")
    private Integer number = 0;
    @ApiModelProperty(value = "儿童人数")
    private Integer childNumber = 0;

    //大人单价"
    @ApiModelProperty(value = "大人单价")
    private BigDecimal price = BigDecimal.ZERO;

    //大人总价
    @ApiModelProperty(value = "大人总价")
    private BigDecimal totalPrice = BigDecimal.ZERO;

    //大人真实总价（优惠后的价格）
    @ApiModelProperty(value = "大人真实总价（优惠后的价格）")
    private BigDecimal realPrice = BigDecimal.ZERO;

    //儿童单价
    @ApiModelProperty(value = "儿童单价")
    private BigDecimal childPrice = BigDecimal.ZERO;

    //儿童总价
    @ApiModelProperty(value = "儿童总价")
    private BigDecimal totalChildPrice = BigDecimal.ZERO;

    //儿童真实总价（优惠后的价格）
    @ApiModelProperty(value = "儿童真实总价（优惠后的价格）")
    private BigDecimal realChildPrice = BigDecimal.ZERO;

    //保险费用
    @ApiModelProperty(value = "保险费用")
    private BigDecimal insureAmount = BigDecimal.ZERO;

    //保险单价
    @ApiModelProperty(value = "保险单价")
    private BigDecimal insurePrice = BigDecimal.ZERO;

    //天数
    @ApiModelProperty(value = "天数")
    private Integer dayNum = 0;

    //总人数
    @ApiModelProperty(value = "总人数")
    private Integer totalNumber = 0;
}
