package com.xxfc.platform.activity.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/23 15:00
 */
@Data
public class CouponDTO {

    @ApiModelProperty("主键id")
    private Integer id;


    @ApiModelProperty(value = "优惠券标题（有图片则显示图片）：无门槛50元优惠券 | 单品最高减2000元")
    private String title;

    @ApiModelProperty(value = "副标题")
    private String subtitle;


    @ApiModelProperty(value = "图片")
    private String icon;


    @ApiModelProperty(value = "可用于：10店铺优惠券 11新人店铺券  20商品优惠券  30类目优惠券  60平台优惠券 61新人平台券")
    private Integer used;


    @ApiModelProperty(value = "0-全平台；1-租车；2-旅游；3-营地")
    private Integer channel;


    @ApiModelProperty(value = "0-普通用户；1-会员用户")
    private Integer userType;


    @ApiModelProperty(value = "1满减券 2叠加满减券 3无门槛券（需要限制大小）")
    private Integer type;


    @ApiModelProperty(value = "1可用于特价商品 2不能  默认不能(商品优惠卷除外)")
    private Integer withSpecial;


    @ApiModelProperty(value = "店铺或商品流水号")
    private String withSn;


    @ApiModelProperty(value = "满多少金额")
    private BigDecimal withAmount;


    @ApiModelProperty(value = "用券抵扣金额")
    private BigDecimal usedAmount;


    @ApiModelProperty(value = "配额：发券数量")
    private Integer quota;


    @ApiModelProperty(value = "每人限领次数")
    private Integer limitCollar;


    @ApiModelProperty(value = "已领取的优惠券数量")
    private Integer takeCount;


    @ApiModelProperty(value = "已使用的优惠券数量")
    private Integer usedCount;


    @ApiModelProperty(value = "发放开始时间")
    private Long startTime;


    @ApiModelProperty(value = "发放结束时间")
    private Long endTime;


    @ApiModelProperty(value = "时效:1绝对时效（领取后XXX-XXX时间段有效）  2相对时效（领取后N天有效）")
    private Integer validType;


    @ApiModelProperty(value = "使用开始时间")
    private Long validStartTime;


    @ApiModelProperty(value = "使用结束时间")
    private Long validEndTime;


    @ApiModelProperty(value = "自领取之日起有效天数")
    private Integer validDays;


    @ApiModelProperty(value = "跳转链接")
    private String url;
}
